package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaUserStatusBuilder extends KafkaUserStatusFluent<KafkaUserStatusBuilder> implements VisitableBuilder<KafkaUserStatus,KafkaUserStatusBuilder>{
  public KafkaUserStatusBuilder() {
    this(new KafkaUserStatus());
  }
  
  public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent) {
    this(fluent, new KafkaUserStatus());
  }
  
  public KafkaUserStatusBuilder(KafkaUserStatusFluent<?> fluent,KafkaUserStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaUserStatusBuilder(KafkaUserStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaUserStatusFluent<?> fluent;
  
  public KafkaUserStatus build() {
    KafkaUserStatus buildable = new KafkaUserStatus();
    buildable.setUsername(fluent.getUsername());
    buildable.setSecret(fluent.getSecret());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}