package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaUserSpecBuilder extends KafkaUserSpecFluent<KafkaUserSpecBuilder> implements VisitableBuilder<KafkaUserSpec,KafkaUserSpecBuilder>{
  public KafkaUserSpecBuilder() {
    this(new KafkaUserSpec());
  }
  
  public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent) {
    this(fluent, new KafkaUserSpec());
  }
  
  public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,KafkaUserSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaUserSpecBuilder(KafkaUserSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaUserSpecFluent<?> fluent;
  
  public KafkaUserSpec build() {
    KafkaUserSpec buildable = new KafkaUserSpec();
    buildable.setAuthentication(fluent.buildAuthentication());
    buildable.setAuthorization(fluent.buildAuthorization());
    buildable.setQuotas(fluent.buildQuotas());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}