package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaUserQuotasBuilder extends KafkaUserQuotasFluent<KafkaUserQuotasBuilder> implements VisitableBuilder<KafkaUserQuotas,KafkaUserQuotasBuilder>{
  public KafkaUserQuotasBuilder() {
    this(new KafkaUserQuotas());
  }
  
  public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent) {
    this(fluent, new KafkaUserQuotas());
  }
  
  public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,KafkaUserQuotas instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaUserQuotasBuilder(KafkaUserQuotas instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaUserQuotasFluent<?> fluent;
  
  public KafkaUserQuotas build() {
    KafkaUserQuotas buildable = new KafkaUserQuotas();
    buildable.setProducerByteRate(fluent.getProducerByteRate());
    buildable.setConsumerByteRate(fluent.getConsumerByteRate());
    buildable.setRequestPercentage(fluent.getRequestPercentage());
    buildable.setControllerMutationRate(fluent.getControllerMutationRate());
    return buildable;
  }
  

}