package io.strimzi.api.kafka.model.user;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaUserFluent<A extends KafkaUserFluent<A>> extends CustomResourceFluent<KafkaUserSpec,KafkaUserStatus,A>{
  public KafkaUserFluent() {
  }
  
  public KafkaUserFluent(KafkaUser instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private KafkaUserSpecBuilder spec;
  private KafkaUserStatusBuilder status;
  
  protected void copyInstance(KafkaUser instance) {
    instance = (instance != null ? instance : new KafkaUser());
    if (instance != null) {
          this.withSpec(instance.getSpec());
          this.withStatus(instance.getStatus());
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public KafkaUserSpec buildSpec() {
    return this.spec != null ? this.spec.build() : null;
  }
  
  public A withSpec(KafkaUserSpec spec) {
    this._visitables.remove("spec");
    if (spec != null) {
        this.spec = new KafkaUserSpecBuilder(spec);
        this._visitables.get("spec").add(this.spec);
    } else {
        this.spec = null;
        this._visitables.get("spec").remove(this.spec);
    }
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  
  public SpecNested<A> withNewSpecLike(KafkaUserSpec item) {
    return new SpecNested(item);
  }
  
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new KafkaUserSpecBuilder().build()));
  }
  
  public SpecNested<A> editOrNewSpecLike(KafkaUserSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  
  public KafkaUserStatus buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(KafkaUserStatus status) {
    this._visitables.remove("status");
    if (status != null) {
        this.status = new KafkaUserStatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(KafkaUserStatus item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new KafkaUserStatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(KafkaUserStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaUserFluent that = (KafkaUserFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  public class SpecNested<N> extends KafkaUserSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(KafkaUserSpec item) {
      this.builder = new KafkaUserSpecBuilder(this, item);
    }
    KafkaUserSpecBuilder builder;
    
    public N and() {
      return (N) KafkaUserFluent.this.withSpec(builder.build());
    }
    
    public N endSpec() {
      return and();
    }
    
  
  }
  public class StatusNested<N> extends KafkaUserStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(KafkaUserStatus item) {
      this.builder = new KafkaUserStatusBuilder(this, item);
    }
    KafkaUserStatusBuilder builder;
    
    public N and() {
      return (N) KafkaUserFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }

}