package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaUserBuilder extends KafkaUserFluent<KafkaUserBuilder> implements VisitableBuilder<KafkaUser,KafkaUserBuilder>{
  public KafkaUserBuilder() {
    this(new KafkaUser());
  }
  
  public KafkaUserBuilder(KafkaUserFluent<?> fluent) {
    this(fluent, new KafkaUser());
  }
  
  public KafkaUserBuilder(KafkaUserFluent<?> fluent,KafkaUser instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaUserBuilder(KafkaUser instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaUserFluent<?> fluent;
  
  public KafkaUser build() {
    KafkaUser buildable = new KafkaUser(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}