package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.user.acl.AclRuleBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.user.acl.AclRuleFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.strimzi.api.kafka.model.user.acl.AclRule;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaUserAuthorizationSimpleFluent<A extends KafkaUserAuthorizationSimpleFluent<A>> extends BaseFluent<A>{
  public KafkaUserAuthorizationSimpleFluent() {
  }
  
  public KafkaUserAuthorizationSimpleFluent(KafkaUserAuthorizationSimple instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AclRuleBuilder> acls;
  
  protected void copyInstance(KafkaUserAuthorizationSimple instance) {
    instance = (instance != null ? instance : new KafkaUserAuthorizationSimple());
    if (instance != null) {
          this.withAcls(instance.getAcls());
        }
  }
  
  public A addToAcls(int index,AclRule item) {
    if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
    AclRuleBuilder builder = new AclRuleBuilder(item);
    if (index < 0 || index >= acls.size()) { _visitables.get("acls").add(builder); acls.add(builder); } else { _visitables.get("acls").add(index, builder); acls.add(index, builder);}
    return (A)this;
  }
  
  public A setToAcls(int index,AclRule item) {
    if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
    AclRuleBuilder builder = new AclRuleBuilder(item);
    if (index < 0 || index >= acls.size()) { _visitables.get("acls").add(builder); acls.add(builder); } else { _visitables.get("acls").set(index, builder); acls.set(index, builder);}
    return (A)this;
  }
  
  public A addToAcls(io.strimzi.api.kafka.model.user.acl.AclRule... items) {
    if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
    for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").add(builder);this.acls.add(builder);} return (A)this;
  }
  
  public A addAllToAcls(Collection<AclRule> items) {
    if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
    for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").add(builder);this.acls.add(builder);} return (A)this;
  }
  
  public A removeFromAcls(io.strimzi.api.kafka.model.user.acl.AclRule... items) {
    if (this.acls == null) return (A)this;
    for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").remove(builder); this.acls.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAcls(Collection<AclRule> items) {
    if (this.acls == null) return (A)this;
    for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").remove(builder); this.acls.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAcls(Predicate<AclRuleBuilder> predicate) {
    if (acls == null) return (A) this;
    final Iterator<AclRuleBuilder> each = acls.iterator();
    final List visitables = _visitables.get("acls");
    while (each.hasNext()) {
      AclRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AclRule> buildAcls() {
    return this.acls != null ? build(acls) : null;
  }
  
  public AclRule buildAcl(int index) {
    return this.acls.get(index).build();
  }
  
  public AclRule buildFirstAcl() {
    return this.acls.get(0).build();
  }
  
  public AclRule buildLastAcl() {
    return this.acls.get(acls.size() - 1).build();
  }
  
  public AclRule buildMatchingAcl(Predicate<AclRuleBuilder> predicate) {
      for (AclRuleBuilder item : acls) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAcl(Predicate<AclRuleBuilder> predicate) {
      for (AclRuleBuilder item : acls) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAcls(List<AclRule> acls) {
    if (this.acls != null) {
      this._visitables.get("acls").clear();
    }
    if (acls != null) {
        this.acls = new ArrayList();
        for (AclRule item : acls) {
          this.addToAcls(item);
        }
    } else {
      this.acls = null;
    }
    return (A) this;
  }
  
  public A withAcls(io.strimzi.api.kafka.model.user.acl.AclRule... acls) {
    if (this.acls != null) {
        this.acls.clear();
        _visitables.remove("acls");
    }
    if (acls != null) {
      for (AclRule item : acls) {
        this.addToAcls(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAcls() {
    return this.acls != null && !this.acls.isEmpty();
  }
  
  public AclsNested<A> addNewAcl() {
    return new AclsNested(-1, null);
  }
  
  public AclsNested<A> addNewAclLike(AclRule item) {
    return new AclsNested(-1, item);
  }
  
  public AclsNested<A> setNewAclLike(int index,AclRule item) {
    return new AclsNested(index, item);
  }
  
  public AclsNested<A> editAcl(int index) {
    if (acls.size() <= index) throw new RuntimeException("Can't edit acls. Index exceeds size.");
    return setNewAclLike(index, buildAcl(index));
  }
  
  public AclsNested<A> editFirstAcl() {
    if (acls.size() == 0) throw new RuntimeException("Can't edit first acls. The list is empty.");
    return setNewAclLike(0, buildAcl(0));
  }
  
  public AclsNested<A> editLastAcl() {
    int index = acls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last acls. The list is empty.");
    return setNewAclLike(index, buildAcl(index));
  }
  
  public AclsNested<A> editMatchingAcl(Predicate<AclRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<acls.size();i++) { 
    if (predicate.test(acls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching acls. No match found.");
    return setNewAclLike(index, buildAcl(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaUserAuthorizationSimpleFluent that = (KafkaUserAuthorizationSimpleFluent) o;
    if (!java.util.Objects.equals(acls, that.acls)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(acls,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (acls != null && !acls.isEmpty()) { sb.append("acls:"); sb.append(acls); }
    sb.append("}");
    return sb.toString();
  }
  public class AclsNested<N> extends AclRuleFluent<AclsNested<N>> implements Nested<N>{
    AclsNested(int index,AclRule item) {
      this.index = index;
      this.builder = new AclRuleBuilder(this, item);
    }
    AclRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaUserAuthorizationSimpleFluent.this.setToAcls(index,builder.build());
    }
    
    public N endAcl() {
      return and();
    }
    
  
  }

}