package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReplicasChangeStatusBuilder extends ReplicasChangeStatusFluent<ReplicasChangeStatusBuilder> implements VisitableBuilder<ReplicasChangeStatus,ReplicasChangeStatusBuilder>{
  public ReplicasChangeStatusBuilder() {
    this(new ReplicasChangeStatus());
  }
  
  public ReplicasChangeStatusBuilder(ReplicasChangeStatusFluent<?> fluent) {
    this(fluent, new ReplicasChangeStatus());
  }
  
  public ReplicasChangeStatusBuilder(ReplicasChangeStatusFluent<?> fluent,ReplicasChangeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReplicasChangeStatusBuilder(ReplicasChangeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReplicasChangeStatusFluent<?> fluent;
  
  public ReplicasChangeStatus build() {
    ReplicasChangeStatus buildable = new ReplicasChangeStatus();
    buildable.setTargetReplicas(fluent.getTargetReplicas());
    buildable.setState(fluent.getState());
    buildable.setSessionId(fluent.getSessionId());
    buildable.setMessage(fluent.getMessage());
    return buildable;
  }
  

}