package io.strimzi.api.kafka.model.topic;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.strimzi.api.kafka.model.kafka.StatusFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaTopicStatusFluent<A extends KafkaTopicStatusFluent<A>> extends StatusFluent<A>{
  public KafkaTopicStatusFluent() {
  }
  
  public KafkaTopicStatusFluent(KafkaTopicStatus instance) {
    this.copyInstance(instance);
  }
  private String topicName;
  private String topicId;
  private ReplicasChangeStatusBuilder replicasChange;
  
  protected void copyInstance(KafkaTopicStatus instance) {
    instance = (instance != null ? instance : new KafkaTopicStatus());
    if (instance != null) {
          this.withTopicName(instance.getTopicName());
          this.withTopicId(instance.getTopicId());
          this.withReplicasChange(instance.getReplicasChange());
          this.withConditions(instance.getConditions());
          this.withObservedGeneration(instance.getObservedGeneration());
        }
  }
  
  public String getTopicName() {
    return this.topicName;
  }
  
  public A withTopicName(String topicName) {
    this.topicName = topicName;
    return (A) this;
  }
  
  public boolean hasTopicName() {
    return this.topicName != null;
  }
  
  public String getTopicId() {
    return this.topicId;
  }
  
  public A withTopicId(String topicId) {
    this.topicId = topicId;
    return (A) this;
  }
  
  public boolean hasTopicId() {
    return this.topicId != null;
  }
  
  public ReplicasChangeStatus buildReplicasChange() {
    return this.replicasChange != null ? this.replicasChange.build() : null;
  }
  
  public A withReplicasChange(ReplicasChangeStatus replicasChange) {
    this._visitables.remove("replicasChange");
    if (replicasChange != null) {
        this.replicasChange = new ReplicasChangeStatusBuilder(replicasChange);
        this._visitables.get("replicasChange").add(this.replicasChange);
    } else {
        this.replicasChange = null;
        this._visitables.get("replicasChange").remove(this.replicasChange);
    }
    return (A) this;
  }
  
  public boolean hasReplicasChange() {
    return this.replicasChange != null;
  }
  
  public ReplicasChangeNested<A> withNewReplicasChange() {
    return new ReplicasChangeNested(null);
  }
  
  public ReplicasChangeNested<A> withNewReplicasChangeLike(ReplicasChangeStatus item) {
    return new ReplicasChangeNested(item);
  }
  
  public ReplicasChangeNested<A> editReplicasChange() {
    return withNewReplicasChangeLike(java.util.Optional.ofNullable(buildReplicasChange()).orElse(null));
  }
  
  public ReplicasChangeNested<A> editOrNewReplicasChange() {
    return withNewReplicasChangeLike(java.util.Optional.ofNullable(buildReplicasChange()).orElse(new ReplicasChangeStatusBuilder().build()));
  }
  
  public ReplicasChangeNested<A> editOrNewReplicasChangeLike(ReplicasChangeStatus item) {
    return withNewReplicasChangeLike(java.util.Optional.ofNullable(buildReplicasChange()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaTopicStatusFluent that = (KafkaTopicStatusFluent) o;
    if (!java.util.Objects.equals(topicName, that.topicName)) return false;
    if (!java.util.Objects.equals(topicId, that.topicId)) return false;
    if (!java.util.Objects.equals(replicasChange, that.replicasChange)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(topicName,  topicId,  replicasChange,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (topicName != null) { sb.append("topicName:"); sb.append(topicName + ","); }
    if (topicId != null) { sb.append("topicId:"); sb.append(topicId + ","); }
    if (replicasChange != null) { sb.append("replicasChange:"); sb.append(replicasChange); }
    sb.append("}");
    return sb.toString();
  }
  public class ReplicasChangeNested<N> extends ReplicasChangeStatusFluent<ReplicasChangeNested<N>> implements Nested<N>{
    ReplicasChangeNested(ReplicasChangeStatus item) {
      this.builder = new ReplicasChangeStatusBuilder(this, item);
    }
    ReplicasChangeStatusBuilder builder;
    
    public N and() {
      return (N) KafkaTopicStatusFluent.this.withReplicasChange(builder.build());
    }
    
    public N endReplicasChange() {
      return and();
    }
    
  
  }

}