package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaTopicStatusBuilder extends KafkaTopicStatusFluent<KafkaTopicStatusBuilder> implements VisitableBuilder<KafkaTopicStatus,KafkaTopicStatusBuilder>{
  public KafkaTopicStatusBuilder() {
    this(new KafkaTopicStatus());
  }
  
  public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent) {
    this(fluent, new KafkaTopicStatus());
  }
  
  public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,KafkaTopicStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaTopicStatusBuilder(KafkaTopicStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaTopicStatusFluent<?> fluent;
  
  public KafkaTopicStatus build() {
    KafkaTopicStatus buildable = new KafkaTopicStatus();
    buildable.setTopicName(fluent.getTopicName());
    buildable.setTopicId(fluent.getTopicId());
    buildable.setReplicasChange(fluent.buildReplicasChange());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}