package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaTopicSpecBuilder extends KafkaTopicSpecFluent<KafkaTopicSpecBuilder> implements VisitableBuilder<KafkaTopicSpec,KafkaTopicSpecBuilder>{
  public KafkaTopicSpecBuilder() {
    this(new KafkaTopicSpec());
  }
  
  public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent) {
    this(fluent, new KafkaTopicSpec());
  }
  
  public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent,KafkaTopicSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaTopicSpecBuilder(KafkaTopicSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaTopicSpecFluent<?> fluent;
  
  public KafkaTopicSpec build() {
    KafkaTopicSpec buildable = new KafkaTopicSpec();
    buildable.setTopicName(fluent.getTopicName());
    buildable.setPartitions(fluent.getPartitions());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}