package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaTopicBuilder extends KafkaTopicFluent<KafkaTopicBuilder> implements VisitableBuilder<KafkaTopic,KafkaTopicBuilder>{
  public KafkaTopicBuilder() {
    this(new KafkaTopic());
  }
  
  public KafkaTopicBuilder(KafkaTopicFluent<?> fluent) {
    this(fluent, new KafkaTopic());
  }
  
  public KafkaTopicBuilder(KafkaTopicFluent<?> fluent,KafkaTopic instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaTopicBuilder(KafkaTopic instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaTopicFluent<?> fluent;
  
  public KafkaTopic build() {
    KafkaTopic buildable = new KafkaTopic(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}