package io.strimzi.api.kafka.model.rebalance;

import java.lang.SuppressWarnings;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.strimzi.api.kafka.model.kafka.StatusFluent;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaRebalanceStatusFluent<A extends KafkaRebalanceStatusFluent<A>> extends StatusFluent<A>{
  public KafkaRebalanceStatusFluent() {
  }
  
  public KafkaRebalanceStatusFluent(KafkaRebalanceStatus instance) {
    this.copyInstance(instance);
  }
  private String sessionId;
  private Map<String,Object> optimizationResult;
  
  protected void copyInstance(KafkaRebalanceStatus instance) {
    instance = (instance != null ? instance : new KafkaRebalanceStatus());
    if (instance != null) {
          this.withSessionId(instance.getSessionId());
          this.withOptimizationResult(instance.getOptimizationResult());
          this.withConditions(instance.getConditions());
          this.withObservedGeneration(instance.getObservedGeneration());
        }
  }
  
  public String getSessionId() {
    return this.sessionId;
  }
  
  public A withSessionId(String sessionId) {
    this.sessionId = sessionId;
    return (A) this;
  }
  
  public boolean hasSessionId() {
    return this.sessionId != null;
  }
  
  public A addToOptimizationResult(String key,Object value) {
    if(this.optimizationResult == null && key != null && value != null) { this.optimizationResult = new LinkedHashMap(); }
    if(key != null && value != null) {this.optimizationResult.put(key, value);} return (A)this;
  }
  
  public A addToOptimizationResult(Map<String,Object> map) {
    if(this.optimizationResult == null && map != null) { this.optimizationResult = new LinkedHashMap(); }
    if(map != null) { this.optimizationResult.putAll(map);} return (A)this;
  }
  
  public A removeFromOptimizationResult(String key) {
    if(this.optimizationResult == null) { return (A) this; }
    if(key != null && this.optimizationResult != null) {this.optimizationResult.remove(key);} return (A)this;
  }
  
  public A removeFromOptimizationResult(Map<String,Object> map) {
    if(this.optimizationResult == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.optimizationResult != null){this.optimizationResult.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getOptimizationResult() {
    return this.optimizationResult;
  }
  
  public <K,V>A withOptimizationResult(Map<String,Object> optimizationResult) {
    if (optimizationResult == null) {
      this.optimizationResult = null;
    } else {
      this.optimizationResult = new LinkedHashMap(optimizationResult);
    }
    return (A) this;
  }
  
  public boolean hasOptimizationResult() {
    return this.optimizationResult != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaRebalanceStatusFluent that = (KafkaRebalanceStatusFluent) o;
    if (!java.util.Objects.equals(sessionId, that.sessionId)) return false;
    if (!java.util.Objects.equals(optimizationResult, that.optimizationResult)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sessionId,  optimizationResult,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sessionId != null) { sb.append("sessionId:"); sb.append(sessionId + ","); }
    if (optimizationResult != null && !optimizationResult.isEmpty()) { sb.append("optimizationResult:"); sb.append(optimizationResult); }
    sb.append("}");
    return sb.toString();
  }
  

}