package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaRebalanceStatusBuilder extends KafkaRebalanceStatusFluent<KafkaRebalanceStatusBuilder> implements VisitableBuilder<KafkaRebalanceStatus,KafkaRebalanceStatusBuilder>{
  public KafkaRebalanceStatusBuilder() {
    this(new KafkaRebalanceStatus());
  }
  
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent) {
    this(fluent, new KafkaRebalanceStatus());
  }
  
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatusFluent<?> fluent,KafkaRebalanceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaRebalanceStatusBuilder(KafkaRebalanceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaRebalanceStatusFluent<?> fluent;
  
  public KafkaRebalanceStatus build() {
    KafkaRebalanceStatus buildable = new KafkaRebalanceStatus();
    buildable.setSessionId(fluent.getSessionId());
    buildable.setOptimizationResult(fluent.getOptimizationResult());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}