package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.common.SpecFluent;
import java.util.function.Predicate;
import java.lang.Integer;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaRebalanceSpecFluent<A extends KafkaRebalanceSpecFluent<A>> extends SpecFluent<A>{
  public KafkaRebalanceSpecFluent() {
  }
  
  public KafkaRebalanceSpecFluent(KafkaRebalanceSpec instance) {
    this.copyInstance(instance);
  }
  private KafkaRebalanceMode mode;
  private List<Integer> brokers;
  private List<String> goals;
  private boolean skipHardGoalCheck;
  private boolean rebalanceDisk;
  private String excludedTopics;
  private int concurrentPartitionMovementsPerBroker;
  private int concurrentIntraBrokerPartitionMovements;
  private int concurrentLeaderMovements;
  private long replicationThrottle;
  private List<String> replicaMovementStrategies;
  private ArrayList<BrokerAndVolumeIdsBuilder> moveReplicasOffVolumes;
  
  protected void copyInstance(KafkaRebalanceSpec instance) {
    instance = (instance != null ? instance : new KafkaRebalanceSpec());
    if (instance != null) {
          this.withMode(instance.getMode());
          this.withBrokers(instance.getBrokers());
          this.withGoals(instance.getGoals());
          this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
          this.withRebalanceDisk(instance.isRebalanceDisk());
          this.withExcludedTopics(instance.getExcludedTopics());
          this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
          this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
          this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
          this.withReplicationThrottle(instance.getReplicationThrottle());
          this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
          this.withMoveReplicasOffVolumes(instance.getMoveReplicasOffVolumes());
        }
  }
  
  public KafkaRebalanceMode getMode() {
    return this.mode;
  }
  
  public A withMode(KafkaRebalanceMode mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public A addToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.add(index, item);
    return (A)this;
  }
  
  public A setToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.set(index, item); return (A)this;
  }
  
  public A addToBrokers(java.lang.Integer... items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  
  public A addAllToBrokers(Collection<Integer> items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  
  public A removeFromBrokers(java.lang.Integer... items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  
  public A removeAllFromBrokers(Collection<Integer> items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  
  public List<Integer> getBrokers() {
    return this.brokers;
  }
  
  public Integer getBroker(int index) {
    return this.brokers.get(index);
  }
  
  public Integer getFirstBroker() {
    return this.brokers.get(0);
  }
  
  public Integer getLastBroker() {
    return this.brokers.get(brokers.size() - 1);
  }
  
  public Integer getMatchingBroker(Predicate<Integer> predicate) {
      for (Integer item : brokers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingBroker(Predicate<Integer> predicate) {
      for (Integer item : brokers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBrokers(List<Integer> brokers) {
    if (brokers != null) {
        this.brokers = new ArrayList();
        for (Integer item : brokers) {
          this.addToBrokers(item);
        }
    } else {
      this.brokers = null;
    }
    return (A) this;
  }
  
  public A withBrokers(java.lang.Integer... brokers) {
    if (this.brokers != null) {
        this.brokers.clear();
        _visitables.remove("brokers");
    }
    if (brokers != null) {
      for (Integer item : brokers) {
        this.addToBrokers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBrokers() {
    return this.brokers != null && !this.brokers.isEmpty();
  }
  
  public A addToGoals(int index,String item) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    this.goals.add(index, item);
    return (A)this;
  }
  
  public A setToGoals(int index,String item) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    this.goals.set(index, item); return (A)this;
  }
  
  public A addToGoals(java.lang.String... items) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    for (String item : items) {this.goals.add(item);} return (A)this;
  }
  
  public A addAllToGoals(Collection<String> items) {
    if (this.goals == null) {this.goals = new ArrayList<String>();}
    for (String item : items) {this.goals.add(item);} return (A)this;
  }
  
  public A removeFromGoals(java.lang.String... items) {
    if (this.goals == null) return (A)this;
    for (String item : items) { this.goals.remove(item);} return (A)this;
  }
  
  public A removeAllFromGoals(Collection<String> items) {
    if (this.goals == null) return (A)this;
    for (String item : items) { this.goals.remove(item);} return (A)this;
  }
  
  public List<String> getGoals() {
    return this.goals;
  }
  
  public String getGoal(int index) {
    return this.goals.get(index);
  }
  
  public String getFirstGoal() {
    return this.goals.get(0);
  }
  
  public String getLastGoal() {
    return this.goals.get(goals.size() - 1);
  }
  
  public String getMatchingGoal(Predicate<String> predicate) {
      for (String item : goals) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingGoal(Predicate<String> predicate) {
      for (String item : goals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGoals(List<String> goals) {
    if (goals != null) {
        this.goals = new ArrayList();
        for (String item : goals) {
          this.addToGoals(item);
        }
    } else {
      this.goals = null;
    }
    return (A) this;
  }
  
  public A withGoals(java.lang.String... goals) {
    if (this.goals != null) {
        this.goals.clear();
        _visitables.remove("goals");
    }
    if (goals != null) {
      for (String item : goals) {
        this.addToGoals(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGoals() {
    return this.goals != null && !this.goals.isEmpty();
  }
  
  public boolean isSkipHardGoalCheck() {
    return this.skipHardGoalCheck;
  }
  
  public A withSkipHardGoalCheck(boolean skipHardGoalCheck) {
    this.skipHardGoalCheck = skipHardGoalCheck;
    return (A) this;
  }
  
  public boolean hasSkipHardGoalCheck() {
    return true;
  }
  
  public boolean isRebalanceDisk() {
    return this.rebalanceDisk;
  }
  
  public A withRebalanceDisk(boolean rebalanceDisk) {
    this.rebalanceDisk = rebalanceDisk;
    return (A) this;
  }
  
  public boolean hasRebalanceDisk() {
    return true;
  }
  
  public String getExcludedTopics() {
    return this.excludedTopics;
  }
  
  public A withExcludedTopics(String excludedTopics) {
    this.excludedTopics = excludedTopics;
    return (A) this;
  }
  
  public boolean hasExcludedTopics() {
    return this.excludedTopics != null;
  }
  
  public int getConcurrentPartitionMovementsPerBroker() {
    return this.concurrentPartitionMovementsPerBroker;
  }
  
  public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker) {
    this.concurrentPartitionMovementsPerBroker = concurrentPartitionMovementsPerBroker;
    return (A) this;
  }
  
  public boolean hasConcurrentPartitionMovementsPerBroker() {
    return true;
  }
  
  public int getConcurrentIntraBrokerPartitionMovements() {
    return this.concurrentIntraBrokerPartitionMovements;
  }
  
  public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements) {
    this.concurrentIntraBrokerPartitionMovements = concurrentIntraBrokerPartitionMovements;
    return (A) this;
  }
  
  public boolean hasConcurrentIntraBrokerPartitionMovements() {
    return true;
  }
  
  public int getConcurrentLeaderMovements() {
    return this.concurrentLeaderMovements;
  }
  
  public A withConcurrentLeaderMovements(int concurrentLeaderMovements) {
    this.concurrentLeaderMovements = concurrentLeaderMovements;
    return (A) this;
  }
  
  public boolean hasConcurrentLeaderMovements() {
    return true;
  }
  
  public long getReplicationThrottle() {
    return this.replicationThrottle;
  }
  
  public A withReplicationThrottle(long replicationThrottle) {
    this.replicationThrottle = replicationThrottle;
    return (A) this;
  }
  
  public boolean hasReplicationThrottle() {
    return true;
  }
  
  public A addToReplicaMovementStrategies(int index,String item) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    this.replicaMovementStrategies.add(index, item);
    return (A)this;
  }
  
  public A setToReplicaMovementStrategies(int index,String item) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    this.replicaMovementStrategies.set(index, item); return (A)this;
  }
  
  public A addToReplicaMovementStrategies(java.lang.String... items) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    for (String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
  }
  
  public A addAllToReplicaMovementStrategies(Collection<String> items) {
    if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new ArrayList<String>();}
    for (String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
  }
  
  public A removeFromReplicaMovementStrategies(java.lang.String... items) {
    if (this.replicaMovementStrategies == null) return (A)this;
    for (String item : items) { this.replicaMovementStrategies.remove(item);} return (A)this;
  }
  
  public A removeAllFromReplicaMovementStrategies(Collection<String> items) {
    if (this.replicaMovementStrategies == null) return (A)this;
    for (String item : items) { this.replicaMovementStrategies.remove(item);} return (A)this;
  }
  
  public List<String> getReplicaMovementStrategies() {
    return this.replicaMovementStrategies;
  }
  
  public String getReplicaMovementStrategy(int index) {
    return this.replicaMovementStrategies.get(index);
  }
  
  public String getFirstReplicaMovementStrategy() {
    return this.replicaMovementStrategies.get(0);
  }
  
  public String getLastReplicaMovementStrategy() {
    return this.replicaMovementStrategies.get(replicaMovementStrategies.size() - 1);
  }
  
  public String getMatchingReplicaMovementStrategy(Predicate<String> predicate) {
      for (String item : replicaMovementStrategies) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingReplicaMovementStrategy(Predicate<String> predicate) {
      for (String item : replicaMovementStrategies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withReplicaMovementStrategies(List<String> replicaMovementStrategies) {
    if (replicaMovementStrategies != null) {
        this.replicaMovementStrategies = new ArrayList();
        for (String item : replicaMovementStrategies) {
          this.addToReplicaMovementStrategies(item);
        }
    } else {
      this.replicaMovementStrategies = null;
    }
    return (A) this;
  }
  
  public A withReplicaMovementStrategies(java.lang.String... replicaMovementStrategies) {
    if (this.replicaMovementStrategies != null) {
        this.replicaMovementStrategies.clear();
        _visitables.remove("replicaMovementStrategies");
    }
    if (replicaMovementStrategies != null) {
      for (String item : replicaMovementStrategies) {
        this.addToReplicaMovementStrategies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasReplicaMovementStrategies() {
    return this.replicaMovementStrategies != null && !this.replicaMovementStrategies.isEmpty();
  }
  
  public A addToMoveReplicasOffVolumes(int index,BrokerAndVolumeIds item) {
    if (this.moveReplicasOffVolumes == null) {this.moveReplicasOffVolumes = new ArrayList<BrokerAndVolumeIdsBuilder>();}
    BrokerAndVolumeIdsBuilder builder = new BrokerAndVolumeIdsBuilder(item);
    if (index < 0 || index >= moveReplicasOffVolumes.size()) { _visitables.get("moveReplicasOffVolumes").add(builder); moveReplicasOffVolumes.add(builder); } else { _visitables.get("moveReplicasOffVolumes").add(index, builder); moveReplicasOffVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToMoveReplicasOffVolumes(int index,BrokerAndVolumeIds item) {
    if (this.moveReplicasOffVolumes == null) {this.moveReplicasOffVolumes = new ArrayList<BrokerAndVolumeIdsBuilder>();}
    BrokerAndVolumeIdsBuilder builder = new BrokerAndVolumeIdsBuilder(item);
    if (index < 0 || index >= moveReplicasOffVolumes.size()) { _visitables.get("moveReplicasOffVolumes").add(builder); moveReplicasOffVolumes.add(builder); } else { _visitables.get("moveReplicasOffVolumes").set(index, builder); moveReplicasOffVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToMoveReplicasOffVolumes(io.strimzi.api.kafka.model.rebalance.BrokerAndVolumeIds... items) {
    if (this.moveReplicasOffVolumes == null) {this.moveReplicasOffVolumes = new ArrayList<BrokerAndVolumeIdsBuilder>();}
    for (BrokerAndVolumeIds item : items) {BrokerAndVolumeIdsBuilder builder = new BrokerAndVolumeIdsBuilder(item);_visitables.get("moveReplicasOffVolumes").add(builder);this.moveReplicasOffVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToMoveReplicasOffVolumes(Collection<BrokerAndVolumeIds> items) {
    if (this.moveReplicasOffVolumes == null) {this.moveReplicasOffVolumes = new ArrayList<BrokerAndVolumeIdsBuilder>();}
    for (BrokerAndVolumeIds item : items) {BrokerAndVolumeIdsBuilder builder = new BrokerAndVolumeIdsBuilder(item);_visitables.get("moveReplicasOffVolumes").add(builder);this.moveReplicasOffVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromMoveReplicasOffVolumes(io.strimzi.api.kafka.model.rebalance.BrokerAndVolumeIds... items) {
    if (this.moveReplicasOffVolumes == null) return (A)this;
    for (BrokerAndVolumeIds item : items) {BrokerAndVolumeIdsBuilder builder = new BrokerAndVolumeIdsBuilder(item);_visitables.get("moveReplicasOffVolumes").remove(builder); this.moveReplicasOffVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMoveReplicasOffVolumes(Collection<BrokerAndVolumeIds> items) {
    if (this.moveReplicasOffVolumes == null) return (A)this;
    for (BrokerAndVolumeIds item : items) {BrokerAndVolumeIdsBuilder builder = new BrokerAndVolumeIdsBuilder(item);_visitables.get("moveReplicasOffVolumes").remove(builder); this.moveReplicasOffVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMoveReplicasOffVolumes(Predicate<BrokerAndVolumeIdsBuilder> predicate) {
    if (moveReplicasOffVolumes == null) return (A) this;
    final Iterator<BrokerAndVolumeIdsBuilder> each = moveReplicasOffVolumes.iterator();
    final List visitables = _visitables.get("moveReplicasOffVolumes");
    while (each.hasNext()) {
      BrokerAndVolumeIdsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<BrokerAndVolumeIds> buildMoveReplicasOffVolumes() {
    return this.moveReplicasOffVolumes != null ? build(moveReplicasOffVolumes) : null;
  }
  
  public BrokerAndVolumeIds buildMoveReplicasOffVolume(int index) {
    return this.moveReplicasOffVolumes.get(index).build();
  }
  
  public BrokerAndVolumeIds buildFirstMoveReplicasOffVolume() {
    return this.moveReplicasOffVolumes.get(0).build();
  }
  
  public BrokerAndVolumeIds buildLastMoveReplicasOffVolume() {
    return this.moveReplicasOffVolumes.get(moveReplicasOffVolumes.size() - 1).build();
  }
  
  public BrokerAndVolumeIds buildMatchingMoveReplicasOffVolume(Predicate<BrokerAndVolumeIdsBuilder> predicate) {
      for (BrokerAndVolumeIdsBuilder item : moveReplicasOffVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMoveReplicasOffVolume(Predicate<BrokerAndVolumeIdsBuilder> predicate) {
      for (BrokerAndVolumeIdsBuilder item : moveReplicasOffVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMoveReplicasOffVolumes(List<BrokerAndVolumeIds> moveReplicasOffVolumes) {
    if (this.moveReplicasOffVolumes != null) {
      this._visitables.get("moveReplicasOffVolumes").clear();
    }
    if (moveReplicasOffVolumes != null) {
        this.moveReplicasOffVolumes = new ArrayList();
        for (BrokerAndVolumeIds item : moveReplicasOffVolumes) {
          this.addToMoveReplicasOffVolumes(item);
        }
    } else {
      this.moveReplicasOffVolumes = null;
    }
    return (A) this;
  }
  
  public A withMoveReplicasOffVolumes(io.strimzi.api.kafka.model.rebalance.BrokerAndVolumeIds... moveReplicasOffVolumes) {
    if (this.moveReplicasOffVolumes != null) {
        this.moveReplicasOffVolumes.clear();
        _visitables.remove("moveReplicasOffVolumes");
    }
    if (moveReplicasOffVolumes != null) {
      for (BrokerAndVolumeIds item : moveReplicasOffVolumes) {
        this.addToMoveReplicasOffVolumes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMoveReplicasOffVolumes() {
    return this.moveReplicasOffVolumes != null && !this.moveReplicasOffVolumes.isEmpty();
  }
  
  public MoveReplicasOffVolumesNested<A> addNewMoveReplicasOffVolume() {
    return new MoveReplicasOffVolumesNested(-1, null);
  }
  
  public MoveReplicasOffVolumesNested<A> addNewMoveReplicasOffVolumeLike(BrokerAndVolumeIds item) {
    return new MoveReplicasOffVolumesNested(-1, item);
  }
  
  public MoveReplicasOffVolumesNested<A> setNewMoveReplicasOffVolumeLike(int index,BrokerAndVolumeIds item) {
    return new MoveReplicasOffVolumesNested(index, item);
  }
  
  public MoveReplicasOffVolumesNested<A> editMoveReplicasOffVolume(int index) {
    if (moveReplicasOffVolumes.size() <= index) throw new RuntimeException("Can't edit moveReplicasOffVolumes. Index exceeds size.");
    return setNewMoveReplicasOffVolumeLike(index, buildMoveReplicasOffVolume(index));
  }
  
  public MoveReplicasOffVolumesNested<A> editFirstMoveReplicasOffVolume() {
    if (moveReplicasOffVolumes.size() == 0) throw new RuntimeException("Can't edit first moveReplicasOffVolumes. The list is empty.");
    return setNewMoveReplicasOffVolumeLike(0, buildMoveReplicasOffVolume(0));
  }
  
  public MoveReplicasOffVolumesNested<A> editLastMoveReplicasOffVolume() {
    int index = moveReplicasOffVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last moveReplicasOffVolumes. The list is empty.");
    return setNewMoveReplicasOffVolumeLike(index, buildMoveReplicasOffVolume(index));
  }
  
  public MoveReplicasOffVolumesNested<A> editMatchingMoveReplicasOffVolume(Predicate<BrokerAndVolumeIdsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<moveReplicasOffVolumes.size();i++) { 
    if (predicate.test(moveReplicasOffVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching moveReplicasOffVolumes. No match found.");
    return setNewMoveReplicasOffVolumeLike(index, buildMoveReplicasOffVolume(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaRebalanceSpecFluent that = (KafkaRebalanceSpecFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(brokers, that.brokers)) return false;
    if (!java.util.Objects.equals(goals, that.goals)) return false;
    if (skipHardGoalCheck != that.skipHardGoalCheck) return false;
    if (rebalanceDisk != that.rebalanceDisk) return false;
    if (!java.util.Objects.equals(excludedTopics, that.excludedTopics)) return false;
    if (concurrentPartitionMovementsPerBroker != that.concurrentPartitionMovementsPerBroker) return false;
    if (concurrentIntraBrokerPartitionMovements != that.concurrentIntraBrokerPartitionMovements) return false;
    if (concurrentLeaderMovements != that.concurrentLeaderMovements) return false;
    if (replicationThrottle != that.replicationThrottle) return false;
    if (!java.util.Objects.equals(replicaMovementStrategies, that.replicaMovementStrategies)) return false;
    if (!java.util.Objects.equals(moveReplicasOffVolumes, that.moveReplicasOffVolumes)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mode,  brokers,  goals,  skipHardGoalCheck,  rebalanceDisk,  excludedTopics,  concurrentPartitionMovementsPerBroker,  concurrentIntraBrokerPartitionMovements,  concurrentLeaderMovements,  replicationThrottle,  replicaMovementStrategies,  moveReplicasOffVolumes,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (brokers != null && !brokers.isEmpty()) { sb.append("brokers:"); sb.append(brokers + ","); }
    if (goals != null && !goals.isEmpty()) { sb.append("goals:"); sb.append(goals + ","); }
    sb.append("skipHardGoalCheck:"); sb.append(skipHardGoalCheck + ",");
    sb.append("rebalanceDisk:"); sb.append(rebalanceDisk + ",");
    if (excludedTopics != null) { sb.append("excludedTopics:"); sb.append(excludedTopics + ","); }
    sb.append("concurrentPartitionMovementsPerBroker:"); sb.append(concurrentPartitionMovementsPerBroker + ",");
    sb.append("concurrentIntraBrokerPartitionMovements:"); sb.append(concurrentIntraBrokerPartitionMovements + ",");
    sb.append("concurrentLeaderMovements:"); sb.append(concurrentLeaderMovements + ",");
    sb.append("replicationThrottle:"); sb.append(replicationThrottle + ",");
    if (replicaMovementStrategies != null && !replicaMovementStrategies.isEmpty()) { sb.append("replicaMovementStrategies:"); sb.append(replicaMovementStrategies + ","); }
    if (moveReplicasOffVolumes != null && !moveReplicasOffVolumes.isEmpty()) { sb.append("moveReplicasOffVolumes:"); sb.append(moveReplicasOffVolumes); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSkipHardGoalCheck() {
    return withSkipHardGoalCheck(true);
  }
  
  public A withRebalanceDisk() {
    return withRebalanceDisk(true);
  }
  public class MoveReplicasOffVolumesNested<N> extends BrokerAndVolumeIdsFluent<MoveReplicasOffVolumesNested<N>> implements Nested<N>{
    MoveReplicasOffVolumesNested(int index,BrokerAndVolumeIds item) {
      this.index = index;
      this.builder = new BrokerAndVolumeIdsBuilder(this, item);
    }
    BrokerAndVolumeIdsBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaRebalanceSpecFluent.this.setToMoveReplicasOffVolumes(index,builder.build());
    }
    
    public N endMoveReplicasOffVolume() {
      return and();
    }
    
  
  }

}