package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaRebalanceSpecBuilder extends KafkaRebalanceSpecFluent<KafkaRebalanceSpecBuilder> implements VisitableBuilder<KafkaRebalanceSpec,KafkaRebalanceSpecBuilder>{
  public KafkaRebalanceSpecBuilder() {
    this(new KafkaRebalanceSpec());
  }
  
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent) {
    this(fluent, new KafkaRebalanceSpec());
  }
  
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent,KafkaRebalanceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaRebalanceSpecBuilder(KafkaRebalanceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaRebalanceSpecFluent<?> fluent;
  
  public KafkaRebalanceSpec build() {
    KafkaRebalanceSpec buildable = new KafkaRebalanceSpec();
    buildable.setMode(fluent.getMode());
    buildable.setBrokers(fluent.getBrokers());
    buildable.setGoals(fluent.getGoals());
    buildable.setSkipHardGoalCheck(fluent.isSkipHardGoalCheck());
    buildable.setRebalanceDisk(fluent.isRebalanceDisk());
    buildable.setExcludedTopics(fluent.getExcludedTopics());
    buildable.setConcurrentPartitionMovementsPerBroker(fluent.getConcurrentPartitionMovementsPerBroker());
    buildable.setConcurrentIntraBrokerPartitionMovements(fluent.getConcurrentIntraBrokerPartitionMovements());
    buildable.setConcurrentLeaderMovements(fluent.getConcurrentLeaderMovements());
    buildable.setReplicationThrottle(fluent.getReplicationThrottle());
    buildable.setReplicaMovementStrategies(fluent.getReplicaMovementStrategies());
    buildable.setMoveReplicasOffVolumes(fluent.buildMoveReplicasOffVolumes());
    return buildable;
  }
  

}