package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaRebalanceBuilder extends KafkaRebalanceFluent<KafkaRebalanceBuilder> implements VisitableBuilder<KafkaRebalance,KafkaRebalanceBuilder>{
  public KafkaRebalanceBuilder() {
    this(new KafkaRebalance());
  }
  
  public KafkaRebalanceBuilder(KafkaRebalanceFluent<?> fluent) {
    this(fluent, new KafkaRebalance());
  }
  
  public KafkaRebalanceBuilder(KafkaRebalanceFluent<?> fluent,KafkaRebalance instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaRebalanceBuilder(KafkaRebalance instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaRebalanceFluent<?> fluent;
  
  public KafkaRebalance build() {
    KafkaRebalance buildable = new KafkaRebalance(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}