package io.strimzi.api.kafka.model.rebalance;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BrokerAndVolumeIdsFluent<A extends BrokerAndVolumeIdsFluent<A>> extends BaseFluent<A>{
  public BrokerAndVolumeIdsFluent() {
  }
  
  public BrokerAndVolumeIdsFluent(BrokerAndVolumeIds instance) {
    this.copyInstance(instance);
  }
  private Integer brokerId;
  private List<Integer> volumeIds;
  
  protected void copyInstance(BrokerAndVolumeIds instance) {
    instance = (instance != null ? instance : new BrokerAndVolumeIds());
    if (instance != null) {
          this.withBrokerId(instance.getBrokerId());
          this.withVolumeIds(instance.getVolumeIds());
        }
  }
  
  public Integer getBrokerId() {
    return this.brokerId;
  }
  
  public A withBrokerId(Integer brokerId) {
    this.brokerId = brokerId;
    return (A) this;
  }
  
  public boolean hasBrokerId() {
    return this.brokerId != null;
  }
  
  public A addToVolumeIds(int index,Integer item) {
    if (this.volumeIds == null) {this.volumeIds = new ArrayList<Integer>();}
    this.volumeIds.add(index, item);
    return (A)this;
  }
  
  public A setToVolumeIds(int index,Integer item) {
    if (this.volumeIds == null) {this.volumeIds = new ArrayList<Integer>();}
    this.volumeIds.set(index, item); return (A)this;
  }
  
  public A addToVolumeIds(java.lang.Integer... items) {
    if (this.volumeIds == null) {this.volumeIds = new ArrayList<Integer>();}
    for (Integer item : items) {this.volumeIds.add(item);} return (A)this;
  }
  
  public A addAllToVolumeIds(Collection<Integer> items) {
    if (this.volumeIds == null) {this.volumeIds = new ArrayList<Integer>();}
    for (Integer item : items) {this.volumeIds.add(item);} return (A)this;
  }
  
  public A removeFromVolumeIds(java.lang.Integer... items) {
    if (this.volumeIds == null) return (A)this;
    for (Integer item : items) { this.volumeIds.remove(item);} return (A)this;
  }
  
  public A removeAllFromVolumeIds(Collection<Integer> items) {
    if (this.volumeIds == null) return (A)this;
    for (Integer item : items) { this.volumeIds.remove(item);} return (A)this;
  }
  
  public List<Integer> getVolumeIds() {
    return this.volumeIds;
  }
  
  public Integer getVolumeId(int index) {
    return this.volumeIds.get(index);
  }
  
  public Integer getFirstVolumeId() {
    return this.volumeIds.get(0);
  }
  
  public Integer getLastVolumeId() {
    return this.volumeIds.get(volumeIds.size() - 1);
  }
  
  public Integer getMatchingVolumeId(Predicate<Integer> predicate) {
      for (Integer item : volumeIds) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeId(Predicate<Integer> predicate) {
      for (Integer item : volumeIds) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeIds(List<Integer> volumeIds) {
    if (volumeIds != null) {
        this.volumeIds = new ArrayList();
        for (Integer item : volumeIds) {
          this.addToVolumeIds(item);
        }
    } else {
      this.volumeIds = null;
    }
    return (A) this;
  }
  
  public A withVolumeIds(java.lang.Integer... volumeIds) {
    if (this.volumeIds != null) {
        this.volumeIds.clear();
        _visitables.remove("volumeIds");
    }
    if (volumeIds != null) {
      for (Integer item : volumeIds) {
        this.addToVolumeIds(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumeIds() {
    return this.volumeIds != null && !this.volumeIds.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BrokerAndVolumeIdsFluent that = (BrokerAndVolumeIdsFluent) o;
    if (!java.util.Objects.equals(brokerId, that.brokerId)) return false;
    if (!java.util.Objects.equals(volumeIds, that.volumeIds)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(brokerId,  volumeIds,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (brokerId != null) { sb.append("brokerId:"); sb.append(brokerId + ","); }
    if (volumeIds != null && !volumeIds.isEmpty()) { sb.append("volumeIds:"); sb.append(volumeIds); }
    sb.append("}");
    return sb.toString();
  }
  

}