package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BrokerAndVolumeIdsBuilder extends BrokerAndVolumeIdsFluent<BrokerAndVolumeIdsBuilder> implements VisitableBuilder<BrokerAndVolumeIds,BrokerAndVolumeIdsBuilder>{
  public BrokerAndVolumeIdsBuilder() {
    this(new BrokerAndVolumeIds());
  }
  
  public BrokerAndVolumeIdsBuilder(BrokerAndVolumeIdsFluent<?> fluent) {
    this(fluent, new BrokerAndVolumeIds());
  }
  
  public BrokerAndVolumeIdsBuilder(BrokerAndVolumeIdsFluent<?> fluent,BrokerAndVolumeIds instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BrokerAndVolumeIdsBuilder(BrokerAndVolumeIds instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BrokerAndVolumeIdsFluent<?> fluent;
  
  public BrokerAndVolumeIds build() {
    BrokerAndVolumeIds buildable = new BrokerAndVolumeIds();
    buildable.setBrokerId(fluent.getBrokerId());
    buildable.setVolumeIds(fluent.getVolumeIds());
    return buildable;
  }
  

}