package io.strimzi.api.kafka.model.podset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StrimziPodSetStatusBuilder extends StrimziPodSetStatusFluent<StrimziPodSetStatusBuilder> implements VisitableBuilder<StrimziPodSetStatus,StrimziPodSetStatusBuilder>{
  public StrimziPodSetStatusBuilder() {
    this(new StrimziPodSetStatus());
  }
  
  public StrimziPodSetStatusBuilder(StrimziPodSetStatusFluent<?> fluent) {
    this(fluent, new StrimziPodSetStatus());
  }
  
  public StrimziPodSetStatusBuilder(StrimziPodSetStatusFluent<?> fluent,StrimziPodSetStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StrimziPodSetStatusBuilder(StrimziPodSetStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StrimziPodSetStatusFluent<?> fluent;
  
  public StrimziPodSetStatus build() {
    StrimziPodSetStatus buildable = new StrimziPodSetStatus();
    buildable.setPods(fluent.getPods());
    buildable.setReadyPods(fluent.getReadyPods());
    buildable.setCurrentPods(fluent.getCurrentPods());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}