package io.strimzi.api.kafka.model.podset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StrimziPodSetSpecBuilder extends StrimziPodSetSpecFluent<StrimziPodSetSpecBuilder> implements VisitableBuilder<StrimziPodSetSpec,StrimziPodSetSpecBuilder>{
  public StrimziPodSetSpecBuilder() {
    this(new StrimziPodSetSpec());
  }
  
  public StrimziPodSetSpecBuilder(StrimziPodSetSpecFluent<?> fluent) {
    this(fluent, new StrimziPodSetSpec());
  }
  
  public StrimziPodSetSpecBuilder(StrimziPodSetSpecFluent<?> fluent,StrimziPodSetSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StrimziPodSetSpecBuilder(StrimziPodSetSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StrimziPodSetSpecFluent<?> fluent;
  
  public StrimziPodSetSpec build() {
    StrimziPodSetSpec buildable = new StrimziPodSetSpec();
    buildable.setSelector(fluent.getSelector());
    buildable.setPods(fluent.getPods());
    return buildable;
  }
  

}