package io.strimzi.api.kafka.model.podset;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StrimziPodSetBuilder extends StrimziPodSetFluent<StrimziPodSetBuilder> implements VisitableBuilder<StrimziPodSet,StrimziPodSetBuilder>{
  public StrimziPodSetBuilder() {
    this(new StrimziPodSet());
  }
  
  public StrimziPodSetBuilder(StrimziPodSetFluent<?> fluent) {
    this(fluent, new StrimziPodSet());
  }
  
  public StrimziPodSetBuilder(StrimziPodSetFluent<?> fluent,StrimziPodSet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StrimziPodSetBuilder(StrimziPodSet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StrimziPodSetFluent<?> fluent;
  
  public StrimziPodSet build() {
    StrimziPodSet buildable = new StrimziPodSet(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}