package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaNodePoolTemplateBuilder extends KafkaNodePoolTemplateFluent<KafkaNodePoolTemplateBuilder> implements VisitableBuilder<KafkaNodePoolTemplate,KafkaNodePoolTemplateBuilder>{
  public KafkaNodePoolTemplateBuilder() {
    this(new KafkaNodePoolTemplate());
  }
  
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplateFluent<?> fluent) {
    this(fluent, new KafkaNodePoolTemplate());
  }
  
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplateFluent<?> fluent,KafkaNodePoolTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaNodePoolTemplateFluent<?> fluent;
  
  public KafkaNodePoolTemplate build() {
    KafkaNodePoolTemplate buildable = new KafkaNodePoolTemplate();
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setPerPodService(fluent.buildPerPodService());
    buildable.setPerPodRoute(fluent.buildPerPodRoute());
    buildable.setPerPodIngress(fluent.buildPerPodIngress());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setKafkaContainer(fluent.buildKafkaContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    return buildable;
  }
  

}