package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaNodePoolStatusBuilder extends KafkaNodePoolStatusFluent<KafkaNodePoolStatusBuilder> implements VisitableBuilder<KafkaNodePoolStatus,KafkaNodePoolStatusBuilder>{
  public KafkaNodePoolStatusBuilder() {
    this(new KafkaNodePoolStatus());
  }
  
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatusFluent<?> fluent) {
    this(fluent, new KafkaNodePoolStatus());
  }
  
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatusFluent<?> fluent,KafkaNodePoolStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaNodePoolStatusBuilder(KafkaNodePoolStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaNodePoolStatusFluent<?> fluent;
  
  public KafkaNodePoolStatus build() {
    KafkaNodePoolStatus buildable = new KafkaNodePoolStatus();
    buildable.setNodeIds(fluent.getNodeIds());
    buildable.setClusterId(fluent.getClusterId());
    buildable.setRoles(fluent.getRoles());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}