package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaNodePoolSpecBuilder extends KafkaNodePoolSpecFluent<KafkaNodePoolSpecBuilder> implements VisitableBuilder<KafkaNodePoolSpec,KafkaNodePoolSpecBuilder>{
  public KafkaNodePoolSpecBuilder() {
    this(new KafkaNodePoolSpec());
  }
  
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpecFluent<?> fluent) {
    this(fluent, new KafkaNodePoolSpec());
  }
  
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpecFluent<?> fluent,KafkaNodePoolSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaNodePoolSpecFluent<?> fluent;
  
  public KafkaNodePoolSpec build() {
    KafkaNodePoolSpec buildable = new KafkaNodePoolSpec();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setStorage(fluent.buildStorage());
    buildable.setRoles(fluent.getRoles());
    buildable.setResources(fluent.getResources());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}