package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaNodePoolBuilder extends KafkaNodePoolFluent<KafkaNodePoolBuilder> implements VisitableBuilder<KafkaNodePool,KafkaNodePoolBuilder>{
  public KafkaNodePoolBuilder() {
    this(new KafkaNodePool());
  }
  
  public KafkaNodePoolBuilder(KafkaNodePoolFluent<?> fluent) {
    this(fluent, new KafkaNodePool());
  }
  
  public KafkaNodePoolBuilder(KafkaNodePoolFluent<?> fluent,KafkaNodePool instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaNodePoolBuilder(KafkaNodePool instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaNodePoolFluent<?> fluent;
  
  public KafkaNodePool build() {
    KafkaNodePool buildable = new KafkaNodePool(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}