package io.strimzi.api.kafka.model.mirrormaker2;

import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateFluent;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaMirrorMaker2TemplateFluent<A extends KafkaMirrorMaker2TemplateFluent<A>> extends BaseFluent<A>{
  public KafkaMirrorMaker2TemplateFluent() {
  }
  
  public KafkaMirrorMaker2TemplateFluent(KafkaMirrorMaker2Template instance) {
    this.copyInstance(instance);
  }
  private DeploymentTemplateBuilder deployment;
  private PodTemplateBuilder pod;
  private InternalServiceTemplateBuilder apiService;
  private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
  private ContainerTemplateBuilder mirrorMaker2Container;
  private ResourceTemplateBuilder serviceAccount;
  private ResourceTemplateBuilder jmxSecret;
  
  protected void copyInstance(KafkaMirrorMaker2Template instance) {
    instance = (instance != null ? instance : new KafkaMirrorMaker2Template());
    if (instance != null) {
          this.withDeployment(instance.getDeployment());
          this.withPod(instance.getPod());
          this.withApiService(instance.getApiService());
          this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
          this.withMirrorMaker2Container(instance.getMirrorMaker2Container());
          this.withServiceAccount(instance.getServiceAccount());
          this.withJmxSecret(instance.getJmxSecret());
        }
  }
  
  public DeploymentTemplate buildDeployment() {
    return this.deployment != null ? this.deployment.build() : null;
  }
  
  public A withDeployment(DeploymentTemplate deployment) {
    this._visitables.remove("deployment");
    if (deployment != null) {
        this.deployment = new DeploymentTemplateBuilder(deployment);
        this._visitables.get("deployment").add(this.deployment);
    } else {
        this.deployment = null;
        this._visitables.get("deployment").remove(this.deployment);
    }
    return (A) this;
  }
  
  public boolean hasDeployment() {
    return this.deployment != null;
  }
  
  public DeploymentNested<A> withNewDeployment() {
    return new DeploymentNested(null);
  }
  
  public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
    return new DeploymentNested(item);
  }
  
  public DeploymentNested<A> editDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(null));
  }
  
  public DeploymentNested<A> editOrNewDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
  }
  
  public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(item));
  }
  
  public PodTemplate buildPod() {
    return this.pod != null ? this.pod.build() : null;
  }
  
  public A withPod(PodTemplate pod) {
    this._visitables.remove("pod");
    if (pod != null) {
        this.pod = new PodTemplateBuilder(pod);
        this._visitables.get("pod").add(this.pod);
    } else {
        this.pod = null;
        this._visitables.get("pod").remove(this.pod);
    }
    return (A) this;
  }
  
  public boolean hasPod() {
    return this.pod != null;
  }
  
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  
  public InternalServiceTemplate buildApiService() {
    return this.apiService != null ? this.apiService.build() : null;
  }
  
  public A withApiService(InternalServiceTemplate apiService) {
    this._visitables.remove("apiService");
    if (apiService != null) {
        this.apiService = new InternalServiceTemplateBuilder(apiService);
        this._visitables.get("apiService").add(this.apiService);
    } else {
        this.apiService = null;
        this._visitables.get("apiService").remove(this.apiService);
    }
    return (A) this;
  }
  
  public boolean hasApiService() {
    return this.apiService != null;
  }
  
  public ApiServiceNested<A> withNewApiService() {
    return new ApiServiceNested(null);
  }
  
  public ApiServiceNested<A> withNewApiServiceLike(InternalServiceTemplate item) {
    return new ApiServiceNested(item);
  }
  
  public ApiServiceNested<A> editApiService() {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(null));
  }
  
  public ApiServiceNested<A> editOrNewApiService() {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  
  public ApiServiceNested<A> editOrNewApiServiceLike(InternalServiceTemplate item) {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(item));
  }
  
  public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
    return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
  }
  
  public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
    this._visitables.remove("podDisruptionBudget");
    if (podDisruptionBudget != null) {
        this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
        this._visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);
    } else {
        this.podDisruptionBudget = null;
        this._visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
    }
    return (A) this;
  }
  
  public boolean hasPodDisruptionBudget() {
    return this.podDisruptionBudget != null;
  }
  
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
    return new PodDisruptionBudgetNested(null);
  }
  
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return new PodDisruptionBudgetNested(item);
  }
  
  public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(null));
  }
  
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
  }
  
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(item));
  }
  
  public ContainerTemplate buildMirrorMaker2Container() {
    return this.mirrorMaker2Container != null ? this.mirrorMaker2Container.build() : null;
  }
  
  public A withMirrorMaker2Container(ContainerTemplate mirrorMaker2Container) {
    this._visitables.remove("mirrorMaker2Container");
    if (mirrorMaker2Container != null) {
        this.mirrorMaker2Container = new ContainerTemplateBuilder(mirrorMaker2Container);
        this._visitables.get("mirrorMaker2Container").add(this.mirrorMaker2Container);
    } else {
        this.mirrorMaker2Container = null;
        this._visitables.get("mirrorMaker2Container").remove(this.mirrorMaker2Container);
    }
    return (A) this;
  }
  
  public boolean hasMirrorMaker2Container() {
    return this.mirrorMaker2Container != null;
  }
  
  public MirrorMaker2ContainerNested<A> withNewMirrorMaker2Container() {
    return new MirrorMaker2ContainerNested(null);
  }
  
  public MirrorMaker2ContainerNested<A> withNewMirrorMaker2ContainerLike(ContainerTemplate item) {
    return new MirrorMaker2ContainerNested(item);
  }
  
  public MirrorMaker2ContainerNested<A> editMirrorMaker2Container() {
    return withNewMirrorMaker2ContainerLike(java.util.Optional.ofNullable(buildMirrorMaker2Container()).orElse(null));
  }
  
  public MirrorMaker2ContainerNested<A> editOrNewMirrorMaker2Container() {
    return withNewMirrorMaker2ContainerLike(java.util.Optional.ofNullable(buildMirrorMaker2Container()).orElse(new ContainerTemplateBuilder().build()));
  }
  
  public MirrorMaker2ContainerNested<A> editOrNewMirrorMaker2ContainerLike(ContainerTemplate item) {
    return withNewMirrorMaker2ContainerLike(java.util.Optional.ofNullable(buildMirrorMaker2Container()).orElse(item));
  }
  
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount != null ? this.serviceAccount.build() : null;
  }
  
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    this._visitables.remove("serviceAccount");
    if (serviceAccount != null) {
        this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
        this._visitables.get("serviceAccount").add(this.serviceAccount);
    } else {
        this.serviceAccount = null;
        this._visitables.get("serviceAccount").remove(this.serviceAccount);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  
  public ResourceTemplate buildJmxSecret() {
    return this.jmxSecret != null ? this.jmxSecret.build() : null;
  }
  
  public A withJmxSecret(ResourceTemplate jmxSecret) {
    this._visitables.remove("jmxSecret");
    if (jmxSecret != null) {
        this.jmxSecret = new ResourceTemplateBuilder(jmxSecret);
        this._visitables.get("jmxSecret").add(this.jmxSecret);
    } else {
        this.jmxSecret = null;
        this._visitables.get("jmxSecret").remove(this.jmxSecret);
    }
    return (A) this;
  }
  
  public boolean hasJmxSecret() {
    return this.jmxSecret != null;
  }
  
  public JmxSecretNested<A> withNewJmxSecret() {
    return new JmxSecretNested(null);
  }
  
  public JmxSecretNested<A> withNewJmxSecretLike(ResourceTemplate item) {
    return new JmxSecretNested(item);
  }
  
  public JmxSecretNested<A> editJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(null));
  }
  
  public JmxSecretNested<A> editOrNewJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public JmxSecretNested<A> editOrNewJmxSecretLike(ResourceTemplate item) {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMaker2TemplateFluent that = (KafkaMirrorMaker2TemplateFluent) o;
    if (!java.util.Objects.equals(deployment, that.deployment)) return false;
    if (!java.util.Objects.equals(pod, that.pod)) return false;
    if (!java.util.Objects.equals(apiService, that.apiService)) return false;
    if (!java.util.Objects.equals(podDisruptionBudget, that.podDisruptionBudget)) return false;
    if (!java.util.Objects.equals(mirrorMaker2Container, that.mirrorMaker2Container)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(jmxSecret, that.jmxSecret)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deployment,  pod,  apiService,  podDisruptionBudget,  mirrorMaker2Container,  serviceAccount,  jmxSecret,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deployment != null) { sb.append("deployment:"); sb.append(deployment + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (apiService != null) { sb.append("apiService:"); sb.append(apiService + ","); }
    if (podDisruptionBudget != null) { sb.append("podDisruptionBudget:"); sb.append(podDisruptionBudget + ","); }
    if (mirrorMaker2Container != null) { sb.append("mirrorMaker2Container:"); sb.append(mirrorMaker2Container + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (jmxSecret != null) { sb.append("jmxSecret:"); sb.append(jmxSecret); }
    sb.append("}");
    return sb.toString();
  }
  public class DeploymentNested<N> extends DeploymentTemplateFluent<DeploymentNested<N>> implements Nested<N>{
    DeploymentNested(DeploymentTemplate item) {
      this.builder = new DeploymentTemplateBuilder(this, item);
    }
    DeploymentTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withDeployment(builder.build());
    }
    
    public N endDeployment() {
      return and();
    }
    
  
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withPod(builder.build());
    }
    
    public N endPod() {
      return and();
    }
    
  
  }
  public class ApiServiceNested<N> extends InternalServiceTemplateFluent<ApiServiceNested<N>> implements Nested<N>{
    ApiServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withApiService(builder.build());
    }
    
    public N endApiService() {
      return and();
    }
    
  
  }
  public class PodDisruptionBudgetNested<N> extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>> implements Nested<N>{
    PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
      this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
    }
    PodDisruptionBudgetTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withPodDisruptionBudget(builder.build());
    }
    
    public N endPodDisruptionBudget() {
      return and();
    }
    
  
  }
  public class MirrorMaker2ContainerNested<N> extends ContainerTemplateFluent<MirrorMaker2ContainerNested<N>> implements Nested<N>{
    MirrorMaker2ContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withMirrorMaker2Container(builder.build());
    }
    
    public N endMirrorMaker2Container() {
      return and();
    }
    
  
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withServiceAccount(builder.build());
    }
    
    public N endServiceAccount() {
      return and();
    }
    
  
  }
  public class JmxSecretNested<N> extends ResourceTemplateFluent<JmxSecretNested<N>> implements Nested<N>{
    JmxSecretNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMaker2TemplateFluent.this.withJmxSecret(builder.build());
    }
    
    public N endJmxSecret() {
      return and();
    }
    
  
  }

}