package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2TemplateBuilder extends KafkaMirrorMaker2TemplateFluent<KafkaMirrorMaker2TemplateBuilder> implements VisitableBuilder<KafkaMirrorMaker2Template,KafkaMirrorMaker2TemplateBuilder>{
  public KafkaMirrorMaker2TemplateBuilder() {
    this(new KafkaMirrorMaker2Template());
  }
  
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2Template());
  }
  
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2TemplateFluent<?> fluent,KafkaMirrorMaker2Template instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2TemplateBuilder(KafkaMirrorMaker2Template instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2TemplateFluent<?> fluent;
  
  public KafkaMirrorMaker2Template build() {
    KafkaMirrorMaker2Template buildable = new KafkaMirrorMaker2Template();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setMirrorMaker2Container(fluent.buildMirrorMaker2Container());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  

}