package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.connector.AutoRestartStatusFluent;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatusFluent;
import io.strimzi.api.kafka.model.connector.AutoRestartStatusBuilder;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;
import io.strimzi.api.kafka.model.connector.AutoRestartStatus;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaMirrorMaker2StatusFluent<A extends KafkaMirrorMaker2StatusFluent<A>> extends KafkaConnectStatusFluent<A>{
  public KafkaMirrorMaker2StatusFluent() {
  }
  
  public KafkaMirrorMaker2StatusFluent(KafkaMirrorMaker2Status instance) {
    this.copyInstance(instance);
  }
  private List<Map<String,Object>> connectors;
  private ArrayList<AutoRestartStatusBuilder> autoRestartStatuses;
  
  protected void copyInstance(KafkaMirrorMaker2Status instance) {
    instance = (instance != null ? instance : new KafkaMirrorMaker2Status());
    if (instance != null) {
          this.withConnectors(instance.getConnectors());
          this.withAutoRestartStatuses(instance.getAutoRestartStatuses());
          this.withUrl(instance.getUrl());
          this.withConnectorPlugins(instance.getConnectorPlugins());
          this.withReplicas(instance.getReplicas());
          this.withLabelSelector(instance.getLabelSelector());
          this.withConditions(instance.getConditions());
          this.withObservedGeneration(instance.getObservedGeneration());
        }
  }
  
  public A addToConnectors(int index,Map<String,Object> item) {
    if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
    this.connectors.add(index, item);
    return (A)this;
  }
  
  public A setToConnectors(int index,Map<String,Object> item) {
    if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
    this.connectors.set(index, item); return (A)this;
  }
  
  public A addToConnectors(Map<String,Object>... items) {
    if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.connectors.add(item);} return (A)this;
  }
  
  public A addAllToConnectors(Collection<Map<String,Object>> items) {
    if (this.connectors == null) {this.connectors = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.connectors.add(item);} return (A)this;
  }
  
  public A removeFromConnectors(Map<String,Object>... items) {
    if (this.connectors == null) return (A)this;
    for (Map<String,Object> item : items) { this.connectors.remove(item);} return (A)this;
  }
  
  public A removeAllFromConnectors(Collection<Map<String,Object>> items) {
    if (this.connectors == null) return (A)this;
    for (Map<String,Object> item : items) { this.connectors.remove(item);} return (A)this;
  }
  
  public List<Map<String,Object>> getConnectors() {
    return this.connectors;
  }
  
  public Map<String,Object> getConnector(int index) {
    return this.connectors.get(index);
  }
  
  public Map<String,Object> getFirstConnector() {
    return this.connectors.get(0);
  }
  
  public Map<String,Object> getLastConnector() {
    return this.connectors.get(connectors.size() - 1);
  }
  
  public Map<String,Object> getMatchingConnector(Predicate<Map<String,Object>> predicate) {
      for (Map<String,Object> item : connectors) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingConnector(Predicate<Map<String,Object>> predicate) {
      for (Map<String,Object> item : connectors) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public <K,V>A withConnectors(List<Map<String,Object>> connectors) {
    if (connectors != null) {
        this.connectors = new ArrayList();
        for (Map<String,Object> item : connectors) {
          this.addToConnectors(item);
        }
    } else {
      this.connectors = null;
    }
    return (A) this;
  }
  
  public A withConnectors(Map<String,Object>... connectors) {
    if (this.connectors != null) {
        this.connectors.clear();
        _visitables.remove("connectors");
    }
    if (connectors != null) {
      for (Map<String,Object> item : connectors) {
        this.addToConnectors(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConnectors() {
    return this.connectors != null && !this.connectors.isEmpty();
  }
  
  public A addToAutoRestartStatuses(int index,AutoRestartStatus item) {
    if (this.autoRestartStatuses == null) {this.autoRestartStatuses = new ArrayList<AutoRestartStatusBuilder>();}
    AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
    if (index < 0 || index >= autoRestartStatuses.size()) { _visitables.get("autoRestartStatuses").add(builder); autoRestartStatuses.add(builder); } else { _visitables.get("autoRestartStatuses").add(index, builder); autoRestartStatuses.add(index, builder);}
    return (A)this;
  }
  
  public A setToAutoRestartStatuses(int index,AutoRestartStatus item) {
    if (this.autoRestartStatuses == null) {this.autoRestartStatuses = new ArrayList<AutoRestartStatusBuilder>();}
    AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);
    if (index < 0 || index >= autoRestartStatuses.size()) { _visitables.get("autoRestartStatuses").add(builder); autoRestartStatuses.add(builder); } else { _visitables.get("autoRestartStatuses").set(index, builder); autoRestartStatuses.set(index, builder);}
    return (A)this;
  }
  
  public A addToAutoRestartStatuses(io.strimzi.api.kafka.model.connector.AutoRestartStatus... items) {
    if (this.autoRestartStatuses == null) {this.autoRestartStatuses = new ArrayList<AutoRestartStatusBuilder>();}
    for (AutoRestartStatus item : items) {AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);_visitables.get("autoRestartStatuses").add(builder);this.autoRestartStatuses.add(builder);} return (A)this;
  }
  
  public A addAllToAutoRestartStatuses(Collection<AutoRestartStatus> items) {
    if (this.autoRestartStatuses == null) {this.autoRestartStatuses = new ArrayList<AutoRestartStatusBuilder>();}
    for (AutoRestartStatus item : items) {AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);_visitables.get("autoRestartStatuses").add(builder);this.autoRestartStatuses.add(builder);} return (A)this;
  }
  
  public A removeFromAutoRestartStatuses(io.strimzi.api.kafka.model.connector.AutoRestartStatus... items) {
    if (this.autoRestartStatuses == null) return (A)this;
    for (AutoRestartStatus item : items) {AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);_visitables.get("autoRestartStatuses").remove(builder); this.autoRestartStatuses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAutoRestartStatuses(Collection<AutoRestartStatus> items) {
    if (this.autoRestartStatuses == null) return (A)this;
    for (AutoRestartStatus item : items) {AutoRestartStatusBuilder builder = new AutoRestartStatusBuilder(item);_visitables.get("autoRestartStatuses").remove(builder); this.autoRestartStatuses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAutoRestartStatuses(Predicate<AutoRestartStatusBuilder> predicate) {
    if (autoRestartStatuses == null) return (A) this;
    final Iterator<AutoRestartStatusBuilder> each = autoRestartStatuses.iterator();
    final List visitables = _visitables.get("autoRestartStatuses");
    while (each.hasNext()) {
      AutoRestartStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AutoRestartStatus> buildAutoRestartStatuses() {
    return this.autoRestartStatuses != null ? build(autoRestartStatuses) : null;
  }
  
  public AutoRestartStatus buildAutoRestartStatus(int index) {
    return this.autoRestartStatuses.get(index).build();
  }
  
  public AutoRestartStatus buildFirstAutoRestartStatus() {
    return this.autoRestartStatuses.get(0).build();
  }
  
  public AutoRestartStatus buildLastAutoRestartStatus() {
    return this.autoRestartStatuses.get(autoRestartStatuses.size() - 1).build();
  }
  
  public AutoRestartStatus buildMatchingAutoRestartStatus(Predicate<AutoRestartStatusBuilder> predicate) {
      for (AutoRestartStatusBuilder item : autoRestartStatuses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAutoRestartStatus(Predicate<AutoRestartStatusBuilder> predicate) {
      for (AutoRestartStatusBuilder item : autoRestartStatuses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAutoRestartStatuses(List<AutoRestartStatus> autoRestartStatuses) {
    if (this.autoRestartStatuses != null) {
      this._visitables.get("autoRestartStatuses").clear();
    }
    if (autoRestartStatuses != null) {
        this.autoRestartStatuses = new ArrayList();
        for (AutoRestartStatus item : autoRestartStatuses) {
          this.addToAutoRestartStatuses(item);
        }
    } else {
      this.autoRestartStatuses = null;
    }
    return (A) this;
  }
  
  public A withAutoRestartStatuses(io.strimzi.api.kafka.model.connector.AutoRestartStatus... autoRestartStatuses) {
    if (this.autoRestartStatuses != null) {
        this.autoRestartStatuses.clear();
        _visitables.remove("autoRestartStatuses");
    }
    if (autoRestartStatuses != null) {
      for (AutoRestartStatus item : autoRestartStatuses) {
        this.addToAutoRestartStatuses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAutoRestartStatuses() {
    return this.autoRestartStatuses != null && !this.autoRestartStatuses.isEmpty();
  }
  
  public AutoRestartStatusesNested<A> addNewAutoRestartStatus() {
    return new AutoRestartStatusesNested(-1, null);
  }
  
  public AutoRestartStatusesNested<A> addNewAutoRestartStatusLike(AutoRestartStatus item) {
    return new AutoRestartStatusesNested(-1, item);
  }
  
  public AutoRestartStatusesNested<A> setNewAutoRestartStatusLike(int index,AutoRestartStatus item) {
    return new AutoRestartStatusesNested(index, item);
  }
  
  public AutoRestartStatusesNested<A> editAutoRestartStatus(int index) {
    if (autoRestartStatuses.size() <= index) throw new RuntimeException("Can't edit autoRestartStatuses. Index exceeds size.");
    return setNewAutoRestartStatusLike(index, buildAutoRestartStatus(index));
  }
  
  public AutoRestartStatusesNested<A> editFirstAutoRestartStatus() {
    if (autoRestartStatuses.size() == 0) throw new RuntimeException("Can't edit first autoRestartStatuses. The list is empty.");
    return setNewAutoRestartStatusLike(0, buildAutoRestartStatus(0));
  }
  
  public AutoRestartStatusesNested<A> editLastAutoRestartStatus() {
    int index = autoRestartStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last autoRestartStatuses. The list is empty.");
    return setNewAutoRestartStatusLike(index, buildAutoRestartStatus(index));
  }
  
  public AutoRestartStatusesNested<A> editMatchingAutoRestartStatus(Predicate<AutoRestartStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<autoRestartStatuses.size();i++) { 
    if (predicate.test(autoRestartStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching autoRestartStatuses. No match found.");
    return setNewAutoRestartStatusLike(index, buildAutoRestartStatus(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMaker2StatusFluent that = (KafkaMirrorMaker2StatusFluent) o;
    if (!java.util.Objects.equals(connectors, that.connectors)) return false;
    if (!java.util.Objects.equals(autoRestartStatuses, that.autoRestartStatuses)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(connectors,  autoRestartStatuses,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectors != null && !connectors.isEmpty()) { sb.append("connectors:"); sb.append(connectors + ","); }
    if (autoRestartStatuses != null && !autoRestartStatuses.isEmpty()) { sb.append("autoRestartStatuses:"); sb.append(autoRestartStatuses); }
    sb.append("}");
    return sb.toString();
  }
  public class AutoRestartStatusesNested<N> extends AutoRestartStatusFluent<AutoRestartStatusesNested<N>> implements Nested<N>{
    AutoRestartStatusesNested(int index,AutoRestartStatus item) {
      this.index = index;
      this.builder = new AutoRestartStatusBuilder(this, item);
    }
    AutoRestartStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaMirrorMaker2StatusFluent.this.setToAutoRestartStatuses(index,builder.build());
    }
    
    public N endAutoRestartStatus() {
      return and();
    }
    
  
  }

}