package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2StatusBuilder extends KafkaMirrorMaker2StatusFluent<KafkaMirrorMaker2StatusBuilder> implements VisitableBuilder<KafkaMirrorMaker2Status,KafkaMirrorMaker2StatusBuilder>{
  public KafkaMirrorMaker2StatusBuilder() {
    this(new KafkaMirrorMaker2Status());
  }
  
  public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2StatusFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2Status());
  }
  
  public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2StatusFluent<?> fluent,KafkaMirrorMaker2Status instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2StatusBuilder(KafkaMirrorMaker2Status instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2StatusFluent<?> fluent;
  
  public KafkaMirrorMaker2Status build() {
    KafkaMirrorMaker2Status buildable = new KafkaMirrorMaker2Status();
    buildable.setConnectors(fluent.getConnectors());
    buildable.setAutoRestartStatuses(fluent.buildAutoRestartStatuses());
    buildable.setUrl(fluent.getUrl());
    buildable.setConnectorPlugins(fluent.buildConnectorPlugins());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}