package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2SpecBuilder extends KafkaMirrorMaker2SpecFluent<KafkaMirrorMaker2SpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2Spec,KafkaMirrorMaker2SpecBuilder>{
  public KafkaMirrorMaker2SpecBuilder() {
    this(new KafkaMirrorMaker2Spec());
  }
  
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2Spec());
  }
  
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,KafkaMirrorMaker2Spec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2Spec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2SpecFluent<?> fluent;
  
  public KafkaMirrorMaker2Spec build() {
    KafkaMirrorMaker2Spec buildable = new KafkaMirrorMaker2Spec();
    buildable.setClusters(fluent.buildClusters());
    buildable.setConnectCluster(fluent.getConnectCluster());
    buildable.setMirrors(fluent.buildMirrors());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setVersion(fluent.getVersion());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTracing(fluent.buildTracing());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setExternalConfiguration(fluent.buildExternalConfiguration());
    buildable.setClientRackInitImage(fluent.getClientRackInitImage());
    buildable.setRack(fluent.buildRack());
    return buildable;
  }
  

}