package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2MirrorSpecBuilder extends KafkaMirrorMaker2MirrorSpecFluent<KafkaMirrorMaker2MirrorSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2MirrorSpec,KafkaMirrorMaker2MirrorSpecBuilder>{
  public KafkaMirrorMaker2MirrorSpecBuilder() {
    this(new KafkaMirrorMaker2MirrorSpec());
  }
  
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2MirrorSpec());
  }
  
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,KafkaMirrorMaker2MirrorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2MirrorSpecFluent<?> fluent;
  
  public KafkaMirrorMaker2MirrorSpec build() {
    KafkaMirrorMaker2MirrorSpec buildable = new KafkaMirrorMaker2MirrorSpec();
    buildable.setSourceCluster(fluent.getSourceCluster());
    buildable.setTargetCluster(fluent.getTargetCluster());
    buildable.setSourceConnector(fluent.buildSourceConnector());
    buildable.setCheckpointConnector(fluent.buildCheckpointConnector());
    buildable.setHeartbeatConnector(fluent.buildHeartbeatConnector());
    buildable.setTopicsPattern(fluent.getTopicsPattern());
    buildable.setTopicsBlacklistPattern(fluent.getTopicsBlacklistPattern());
    buildable.setTopicsExcludePattern(fluent.getTopicsExcludePattern());
    buildable.setGroupsPattern(fluent.getGroupsPattern());
    buildable.setGroupsBlacklistPattern(fluent.getGroupsBlacklistPattern());
    buildable.setGroupsExcludePattern(fluent.getGroupsExcludePattern());
    return buildable;
  }
  

}