package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2ConnectorSpecBuilder extends KafkaMirrorMaker2ConnectorSpecFluent<KafkaMirrorMaker2ConnectorSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2ConnectorSpec,KafkaMirrorMaker2ConnectorSpecBuilder>{
  public KafkaMirrorMaker2ConnectorSpecBuilder() {
    this(new KafkaMirrorMaker2ConnectorSpec());
  }
  
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2ConnectorSpec());
  }
  
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,KafkaMirrorMaker2ConnectorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2ConnectorSpecFluent<?> fluent;
  
  public KafkaMirrorMaker2ConnectorSpec build() {
    KafkaMirrorMaker2ConnectorSpec buildable = new KafkaMirrorMaker2ConnectorSpec();
    buildable.setTasksMax(fluent.getTasksMax());
    buildable.setPause(fluent.getPause());
    buildable.setConfig(fluent.getConfig());
    buildable.setState(fluent.getState());
    buildable.setAutoRestart(fluent.buildAutoRestart());
    buildable.setListOffsets(fluent.buildListOffsets());
    buildable.setAlterOffsets(fluent.buildAlterOffsets());
    return buildable;
  }
  

}