package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2ClusterSpecBuilder extends KafkaMirrorMaker2ClusterSpecFluent<KafkaMirrorMaker2ClusterSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2ClusterSpec,KafkaMirrorMaker2ClusterSpecBuilder>{
  public KafkaMirrorMaker2ClusterSpecBuilder() {
    this(new KafkaMirrorMaker2ClusterSpec());
  }
  
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2ClusterSpec());
  }
  
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,KafkaMirrorMaker2ClusterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2ClusterSpecFluent<?> fluent;
  
  public KafkaMirrorMaker2ClusterSpec build() {
    KafkaMirrorMaker2ClusterSpec buildable = new KafkaMirrorMaker2ClusterSpec();
    buildable.setAlias(fluent.getAlias());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  

}