package io.strimzi.api.kafka.model.mirrormaker2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMaker2Builder extends KafkaMirrorMaker2Fluent<KafkaMirrorMaker2Builder> implements VisitableBuilder<KafkaMirrorMaker2,KafkaMirrorMaker2Builder>{
  public KafkaMirrorMaker2Builder() {
    this(new KafkaMirrorMaker2());
  }
  
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker2());
  }
  
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2Fluent<?> fluent,KafkaMirrorMaker2 instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMaker2Builder(KafkaMirrorMaker2 instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMaker2Fluent<?> fluent;
  
  public KafkaMirrorMaker2 build() {
    KafkaMirrorMaker2 buildable = new KafkaMirrorMaker2(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}