package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerTemplateBuilder extends KafkaMirrorMakerTemplateFluent<KafkaMirrorMakerTemplateBuilder> implements VisitableBuilder<KafkaMirrorMakerTemplate,KafkaMirrorMakerTemplateBuilder>{
  public KafkaMirrorMakerTemplateBuilder() {
    this(new KafkaMirrorMakerTemplate());
  }
  
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent) {
    this(fluent, new KafkaMirrorMakerTemplate());
  }
  
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplateFluent<?> fluent,KafkaMirrorMakerTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerTemplateBuilder(KafkaMirrorMakerTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerTemplateFluent<?> fluent;
  
  public KafkaMirrorMakerTemplate build() {
    KafkaMirrorMakerTemplate buildable = new KafkaMirrorMakerTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setMirrorMakerContainer(fluent.buildMirrorMakerContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  

}