package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerStatusBuilder extends KafkaMirrorMakerStatusFluent<KafkaMirrorMakerStatusBuilder> implements VisitableBuilder<KafkaMirrorMakerStatus,KafkaMirrorMakerStatusBuilder>{
  public KafkaMirrorMakerStatusBuilder() {
    this(new KafkaMirrorMakerStatus());
  }
  
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent) {
    this(fluent, new KafkaMirrorMakerStatus());
  }
  
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,KafkaMirrorMakerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerStatusFluent<?> fluent;
  
  public KafkaMirrorMakerStatus build() {
    KafkaMirrorMakerStatus buildable = new KafkaMirrorMakerStatus();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}