package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import java.lang.String;
import io.strimzi.api.kafka.model.common.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracing;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import io.strimzi.api.kafka.model.common.tracing.OpenTelemetryTracingBuilder;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracingBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.common.SpecFluent;
import io.strimzi.api.kafka.model.common.ExternalLogging;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaMirrorMakerSpecFluent<A extends KafkaMirrorMakerSpecFluent<A>> extends SpecFluent<A>{
  public KafkaMirrorMakerSpecFluent() {
  }
  
  public KafkaMirrorMakerSpecFluent(KafkaMirrorMakerSpec instance) {
    this.copyInstance(instance);
  }
  private int replicas;
  private String version;
  private String image;
  private String whitelist;
  private String include;
  private KafkaMirrorMakerConsumerSpecBuilder consumer;
  private KafkaMirrorMakerProducerSpecBuilder producer;
  private ResourceRequirements resources;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private JvmOptionsBuilder jvmOptions;
  private VisitableBuilder<? extends Logging,?> logging;
  private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
  private VisitableBuilder<? extends Tracing,?> tracing;
  private KafkaMirrorMakerTemplateBuilder template;
  
  protected void copyInstance(KafkaMirrorMakerSpec instance) {
    instance = (instance != null ? instance : new KafkaMirrorMakerSpec());
    if (instance != null) {
          this.withReplicas(instance.getReplicas());
          this.withVersion(instance.getVersion());
          this.withImage(instance.getImage());
          this.withWhitelist(instance.getWhitelist());
          this.withInclude(instance.getInclude());
          this.withConsumer(instance.getConsumer());
          this.withProducer(instance.getProducer());
          this.withResources(instance.getResources());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withJvmOptions(instance.getJvmOptions());
          this.withLogging(instance.getLogging());
          this.withMetricsConfig(instance.getMetricsConfig());
          this.withTracing(instance.getTracing());
          this.withTemplate(instance.getTemplate());
        }
  }
  
  public int getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(int replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return true;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getWhitelist() {
    return this.whitelist;
  }
  
  public A withWhitelist(String whitelist) {
    this.whitelist = whitelist;
    return (A) this;
  }
  
  public boolean hasWhitelist() {
    return this.whitelist != null;
  }
  
  public String getInclude() {
    return this.include;
  }
  
  public A withInclude(String include) {
    this.include = include;
    return (A) this;
  }
  
  public boolean hasInclude() {
    return this.include != null;
  }
  
  public KafkaMirrorMakerConsumerSpec buildConsumer() {
    return this.consumer != null ? this.consumer.build() : null;
  }
  
  public A withConsumer(KafkaMirrorMakerConsumerSpec consumer) {
    this._visitables.remove("consumer");
    if (consumer != null) {
        this.consumer = new KafkaMirrorMakerConsumerSpecBuilder(consumer);
        this._visitables.get("consumer").add(this.consumer);
    } else {
        this.consumer = null;
        this._visitables.get("consumer").remove(this.consumer);
    }
    return (A) this;
  }
  
  public boolean hasConsumer() {
    return this.consumer != null;
  }
  
  public ConsumerNested<A> withNewConsumer() {
    return new ConsumerNested(null);
  }
  
  public ConsumerNested<A> withNewConsumerLike(KafkaMirrorMakerConsumerSpec item) {
    return new ConsumerNested(item);
  }
  
  public ConsumerNested<A> editConsumer() {
    return withNewConsumerLike(java.util.Optional.ofNullable(buildConsumer()).orElse(null));
  }
  
  public ConsumerNested<A> editOrNewConsumer() {
    return withNewConsumerLike(java.util.Optional.ofNullable(buildConsumer()).orElse(new KafkaMirrorMakerConsumerSpecBuilder().build()));
  }
  
  public ConsumerNested<A> editOrNewConsumerLike(KafkaMirrorMakerConsumerSpec item) {
    return withNewConsumerLike(java.util.Optional.ofNullable(buildConsumer()).orElse(item));
  }
  
  public KafkaMirrorMakerProducerSpec buildProducer() {
    return this.producer != null ? this.producer.build() : null;
  }
  
  public A withProducer(KafkaMirrorMakerProducerSpec producer) {
    this._visitables.remove("producer");
    if (producer != null) {
        this.producer = new KafkaMirrorMakerProducerSpecBuilder(producer);
        this._visitables.get("producer").add(this.producer);
    } else {
        this.producer = null;
        this._visitables.get("producer").remove(this.producer);
    }
    return (A) this;
  }
  
  public boolean hasProducer() {
    return this.producer != null;
  }
  
  public ProducerNested<A> withNewProducer() {
    return new ProducerNested(null);
  }
  
  public ProducerNested<A> withNewProducerLike(KafkaMirrorMakerProducerSpec item) {
    return new ProducerNested(item);
  }
  
  public ProducerNested<A> editProducer() {
    return withNewProducerLike(java.util.Optional.ofNullable(buildProducer()).orElse(null));
  }
  
  public ProducerNested<A> editOrNewProducer() {
    return withNewProducerLike(java.util.Optional.ofNullable(buildProducer()).orElse(new KafkaMirrorMakerProducerSpecBuilder().build()));
  }
  
  public ProducerNested<A> editOrNewProducerLike(KafkaMirrorMakerProducerSpec item) {
    return withNewProducerLike(java.util.Optional.ofNullable(buildProducer()).orElse(item));
  }
  
  public ResourceRequirements getResources() {
    return this.resources;
  }
  
  public A withResources(ResourceRequirements resources) {
    this.resources = resources;
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public Probe buildLivenessProbe() {
    return this.livenessProbe != null ? this.livenessProbe.build() : null;
  }
  
  public A withLivenessProbe(Probe livenessProbe) {
    this._visitables.remove("livenessProbe");
    if (livenessProbe != null) {
        this.livenessProbe = new ProbeBuilder(livenessProbe);
        this._visitables.get("livenessProbe").add(this.livenessProbe);
    } else {
        this.livenessProbe = null;
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
    }
    return (A) this;
  }
  
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  
  public Probe buildReadinessProbe() {
    return this.readinessProbe != null ? this.readinessProbe.build() : null;
  }
  
  public A withReadinessProbe(Probe readinessProbe) {
    this._visitables.remove("readinessProbe");
    if (readinessProbe != null) {
        this.readinessProbe = new ProbeBuilder(readinessProbe);
        this._visitables.get("readinessProbe").add(this.readinessProbe);
    } else {
        this.readinessProbe = null;
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
    }
    return (A) this;
  }
  
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions != null ? this.jvmOptions.build() : null;
  }
  
  public A withJvmOptions(JvmOptions jvmOptions) {
    this._visitables.remove("jvmOptions");
    if (jvmOptions != null) {
        this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
        this._visitables.get("jvmOptions").add(this.jvmOptions);
    } else {
        this.jvmOptions = null;
        this._visitables.get("jvmOptions").remove(this.jvmOptions);
    }
    return (A) this;
  }
  
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  
  public Logging buildLogging() {
    return this.logging != null ? this.logging.build() : null;
  }
  
  public A withLogging(Logging logging) {
    if (logging == null) {
        this.logging = null;
        this._visitables.remove("logging");
        return (A) this;
    } else {
        VisitableBuilder<? extends Logging,?> builder = builder(logging);;
        this._visitables.get("logging").clear();
        this._visitables.get("logging").add(builder);
        this.logging = builder;
        return (A) this;
    }
  }
  
  public boolean hasLogging() {
    return this.logging != null;
  }
  
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  
  public MetricsConfig buildMetricsConfig() {
    return this.metricsConfig != null ? this.metricsConfig.build() : null;
  }
  
  public A withMetricsConfig(MetricsConfig metricsConfig) {
    if (metricsConfig == null) {
        this.metricsConfig = null;
        this._visitables.remove("metricsConfig");
        return (A) this;
    } else {
        VisitableBuilder<? extends MetricsConfig,?> builder = builder(metricsConfig);;
        this._visitables.get("metricsConfig").clear();
        this._visitables.get("metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A) this;
    }
  }
  
  public boolean hasMetricsConfig() {
    return this.metricsConfig != null;
  }
  
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
    return new JmxPrometheusExporterMetricsConfigNested(null);
  }
  
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
    return new JmxPrometheusExporterMetricsConfigNested(item);
  }
  
  public Tracing buildTracing() {
    return this.tracing != null ? this.tracing.build() : null;
  }
  
  public A withTracing(Tracing tracing) {
    if (tracing == null) {
        this.tracing = null;
        this._visitables.remove("tracing");
        return (A) this;
    } else {
        VisitableBuilder<? extends Tracing,?> builder = builder(tracing);;
        this._visitables.get("tracing").clear();
        this._visitables.get("tracing").add(builder);
        this.tracing = builder;
        return (A) this;
    }
  }
  
  public boolean hasTracing() {
    return this.tracing != null;
  }
  
  public JaegerTracingNested<A> withNewJaegerTracing() {
    return new JaegerTracingNested(null);
  }
  
  public JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
    return new JaegerTracingNested(item);
  }
  
  public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracing() {
    return new OpenTelemetryTracingNested(null);
  }
  
  public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracingLike(OpenTelemetryTracing item) {
    return new OpenTelemetryTracingNested(item);
  }
  
  public KafkaMirrorMakerTemplate buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(KafkaMirrorMakerTemplate template) {
    this._visitables.remove("template");
    if (template != null) {
        this.template = new KafkaMirrorMakerTemplateBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(KafkaMirrorMakerTemplate item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaMirrorMakerTemplateBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(KafkaMirrorMakerTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMakerSpecFluent that = (KafkaMirrorMakerSpecFluent) o;
    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(whitelist, that.whitelist)) return false;
    if (!java.util.Objects.equals(include, that.include)) return false;
    if (!java.util.Objects.equals(consumer, that.consumer)) return false;
    if (!java.util.Objects.equals(producer, that.producer)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;
    if (!java.util.Objects.equals(logging, that.logging)) return false;
    if (!java.util.Objects.equals(metricsConfig, that.metricsConfig)) return false;
    if (!java.util.Objects.equals(tracing, that.tracing)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(replicas,  version,  image,  whitelist,  include,  consumer,  producer,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  logging,  metricsConfig,  tracing,  template,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("replicas:"); sb.append(replicas + ",");
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (whitelist != null) { sb.append("whitelist:"); sb.append(whitelist + ","); }
    if (include != null) { sb.append("include:"); sb.append(include + ","); }
    if (consumer != null) { sb.append("consumer:"); sb.append(consumer + ","); }
    if (producer != null) { sb.append("producer:"); sb.append(producer + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (metricsConfig != null) { sb.append("metricsConfig:"); sb.append(metricsConfig + ","); }
    if (tracing != null) { sb.append("tracing:"); sb.append(tracing + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model.common."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model.common.metrics."+"JmxPrometheusExporterMetrics": return (VisitableBuilder<T, ?>)new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics) item);
    case "io.strimzi.api.kafka.model.common.tracing."+"JaegerTracing": return (VisitableBuilder<T, ?>)new JaegerTracingBuilder((JaegerTracing) item);
    case "io.strimzi.api.kafka.model.common.tracing."+"OpenTelemetryTracing": return (VisitableBuilder<T, ?>)new OpenTelemetryTracingBuilder((OpenTelemetryTracing) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ConsumerNested<N> extends KafkaMirrorMakerConsumerSpecFluent<ConsumerNested<N>> implements Nested<N>{
    ConsumerNested(KafkaMirrorMakerConsumerSpec item) {
      this.builder = new KafkaMirrorMakerConsumerSpecBuilder(this, item);
    }
    KafkaMirrorMakerConsumerSpecBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withConsumer(builder.build());
    }
    
    public N endConsumer() {
      return and();
    }
    
  
  }
  public class ProducerNested<N> extends KafkaMirrorMakerProducerSpecFluent<ProducerNested<N>> implements Nested<N>{
    ProducerNested(KafkaMirrorMakerProducerSpec item) {
      this.builder = new KafkaMirrorMakerProducerSpecBuilder(this, item);
    }
    KafkaMirrorMakerProducerSpecBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withProducer(builder.build());
    }
    
    public N endProducer() {
      return and();
    }
    
  
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withLivenessProbe(builder.build());
    }
    
    public N endLivenessProbe() {
      return and();
    }
    
  
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withReadinessProbe(builder.build());
    }
    
    public N endReadinessProbe() {
      return and();
    }
    
  
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withJvmOptions(builder.build());
    }
    
    public N endJvmOptions() {
      return and();
    }
    
  
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withLogging(builder.build());
    }
    
    public N endInlineLogging() {
      return and();
    }
    
  
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withLogging(builder.build());
    }
    
    public N endExternalLogging() {
      return and();
    }
    
  
  }
  public class JmxPrometheusExporterMetricsConfigNested<N> extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>> implements Nested<N>{
    JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
      this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
    }
    JmxPrometheusExporterMetricsBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withMetricsConfig(builder.build());
    }
    
    public N endJmxPrometheusExporterMetricsConfig() {
      return and();
    }
    
  
  }
  public class JaegerTracingNested<N> extends JaegerTracingFluent<JaegerTracingNested<N>> implements Nested<N>{
    JaegerTracingNested(JaegerTracing item) {
      this.builder = new JaegerTracingBuilder(this, item);
    }
    JaegerTracingBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withTracing(builder.build());
    }
    
    public N endJaegerTracing() {
      return and();
    }
    
  
  }
  public class OpenTelemetryTracingNested<N> extends OpenTelemetryTracingFluent<OpenTelemetryTracingNested<N>> implements Nested<N>{
    OpenTelemetryTracingNested(OpenTelemetryTracing item) {
      this.builder = new OpenTelemetryTracingBuilder(this, item);
    }
    OpenTelemetryTracingBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withTracing(builder.build());
    }
    
    public N endOpenTelemetryTracing() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends KafkaMirrorMakerTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaMirrorMakerTemplate item) {
      this.builder = new KafkaMirrorMakerTemplateBuilder(this, item);
    }
    KafkaMirrorMakerTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaMirrorMakerSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}