package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerSpecBuilder extends KafkaMirrorMakerSpecFluent<KafkaMirrorMakerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerSpec,KafkaMirrorMakerSpecBuilder>{
  public KafkaMirrorMakerSpecBuilder() {
    this(new KafkaMirrorMakerSpec());
  }
  
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMakerSpec());
  }
  
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,KafkaMirrorMakerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerSpecFluent<?> fluent;
  
  public KafkaMirrorMakerSpec build() {
    KafkaMirrorMakerSpec buildable = new KafkaMirrorMakerSpec();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setVersion(fluent.getVersion());
    buildable.setImage(fluent.getImage());
    buildable.setWhitelist(fluent.getWhitelist());
    buildable.setInclude(fluent.getInclude());
    buildable.setConsumer(fluent.buildConsumer());
    buildable.setProducer(fluent.buildProducer());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setLogging(fluent.buildLogging());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTracing(fluent.buildTracing());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}