package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerProducerSpecBuilder extends KafkaMirrorMakerProducerSpecFluent<KafkaMirrorMakerProducerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerProducerSpec,KafkaMirrorMakerProducerSpecBuilder>{
  public KafkaMirrorMakerProducerSpecBuilder() {
    this(new KafkaMirrorMakerProducerSpec());
  }
  
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMakerProducerSpec());
  }
  
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpecFluent<?> fluent,KafkaMirrorMakerProducerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerProducerSpecBuilder(KafkaMirrorMakerProducerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerProducerSpecFluent<?> fluent;
  
  public KafkaMirrorMakerProducerSpec build() {
    KafkaMirrorMakerProducerSpec buildable = new KafkaMirrorMakerProducerSpec();
    buildable.setAbortOnSendFailure(fluent.getAbortOnSendFailure());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  

}