package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerConsumerSpecBuilder extends KafkaMirrorMakerConsumerSpecFluent<KafkaMirrorMakerConsumerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerConsumerSpec,KafkaMirrorMakerConsumerSpecBuilder>{
  public KafkaMirrorMakerConsumerSpecBuilder() {
    this(new KafkaMirrorMakerConsumerSpec());
  }
  
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMakerConsumerSpec());
  }
  
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpecFluent<?> fluent,KafkaMirrorMakerConsumerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerConsumerSpecBuilder(KafkaMirrorMakerConsumerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerConsumerSpecFluent<?> fluent;
  
  public KafkaMirrorMakerConsumerSpec build() {
    KafkaMirrorMakerConsumerSpec buildable = new KafkaMirrorMakerConsumerSpec();
    buildable.setNumStreams(fluent.getNumStreams());
    buildable.setGroupId(fluent.getGroupId());
    buildable.setOffsetCommitInterval(fluent.getOffsetCommitInterval());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  

}