package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerClientSpecBuilder extends KafkaMirrorMakerClientSpecFluent<KafkaMirrorMakerClientSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerClientSpec,KafkaMirrorMakerClientSpecBuilder>{
  public KafkaMirrorMakerClientSpecBuilder() {
    this(new KafkaMirrorMakerClientSpec());
  }
  
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent) {
    this(fluent, new KafkaMirrorMakerClientSpec());
  }
  
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,KafkaMirrorMakerClientSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerClientSpecFluent<?> fluent;
  
  public KafkaMirrorMakerClientSpec build() {
    KafkaMirrorMakerClientSpec buildable = new KafkaMirrorMakerClientSpec();
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  

}