package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaMirrorMakerBuilder extends KafkaMirrorMakerFluent<KafkaMirrorMakerBuilder> implements VisitableBuilder<KafkaMirrorMaker,KafkaMirrorMakerBuilder>{
  public KafkaMirrorMakerBuilder() {
    this(new KafkaMirrorMaker());
  }
  
  public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent) {
    this(fluent, new KafkaMirrorMaker());
  }
  
  public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,KafkaMirrorMaker instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaMirrorMakerBuilder(KafkaMirrorMaker instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaMirrorMakerFluent<?> fluent;
  
  public KafkaMirrorMaker build() {
    KafkaMirrorMaker buildable = new KafkaMirrorMaker(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}