package io.strimzi.api.kafka.model.kafka.tieredstorage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TieredStorageCustomBuilder extends TieredStorageCustomFluent<TieredStorageCustomBuilder> implements VisitableBuilder<TieredStorageCustom,TieredStorageCustomBuilder>{
  public TieredStorageCustomBuilder() {
    this(new TieredStorageCustom());
  }
  
  public TieredStorageCustomBuilder(TieredStorageCustomFluent<?> fluent) {
    this(fluent, new TieredStorageCustom());
  }
  
  public TieredStorageCustomBuilder(TieredStorageCustomFluent<?> fluent,TieredStorageCustom instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TieredStorageCustomBuilder(TieredStorageCustom instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TieredStorageCustomFluent<?> fluent;
  
  public TieredStorageCustom build() {
    TieredStorageCustom buildable = new TieredStorageCustom();
    buildable.setRemoteStorageManager(fluent.buildRemoteStorageManager());
    return buildable;
  }
  

}