package io.strimzi.api.kafka.model.kafka.tieredstorage;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RemoteStorageManagerFluent<A extends RemoteStorageManagerFluent<A>> extends BaseFluent<A>{
  public RemoteStorageManagerFluent() {
  }
  
  public RemoteStorageManagerFluent(RemoteStorageManager instance) {
    this.copyInstance(instance);
  }
  private String className;
  private String classPath;
  private Map<String,String> config;
  
  protected void copyInstance(RemoteStorageManager instance) {
    instance = (instance != null ? instance : new RemoteStorageManager());
    if (instance != null) {
          this.withClassName(instance.getClassName());
          this.withClassPath(instance.getClassPath());
          this.withConfig(instance.getConfig());
        }
  }
  
  public String getClassName() {
    return this.className;
  }
  
  public A withClassName(String className) {
    this.className = className;
    return (A) this;
  }
  
  public boolean hasClassName() {
    return this.className != null;
  }
  
  public String getClassPath() {
    return this.classPath;
  }
  
  public A withClassPath(String classPath) {
    this.classPath = classPath;
    return (A) this;
  }
  
  public boolean hasClassPath() {
    return this.classPath != null;
  }
  
  public A addToConfig(String key,String value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  
  public A addToConfig(Map<String,String> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  
  public A removeFromConfig(Map<String,String> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getConfig() {
    return this.config;
  }
  
  public <K,V>A withConfig(Map<String,String> config) {
    if (config == null) {
      this.config = null;
    } else {
      this.config = new LinkedHashMap(config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RemoteStorageManagerFluent that = (RemoteStorageManagerFluent) o;
    if (!java.util.Objects.equals(className, that.className)) return false;
    if (!java.util.Objects.equals(classPath, that.classPath)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(className,  classPath,  config,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (className != null) { sb.append("className:"); sb.append(className + ","); }
    if (classPath != null) { sb.append("classPath:"); sb.append(classPath + ","); }
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config); }
    sb.append("}");
    return sb.toString();
  }
  

}