package io.strimzi.api.kafka.model.kafka.tieredstorage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RemoteStorageManagerBuilder extends RemoteStorageManagerFluent<RemoteStorageManagerBuilder> implements VisitableBuilder<RemoteStorageManager,RemoteStorageManagerBuilder>{
  public RemoteStorageManagerBuilder() {
    this(new RemoteStorageManager());
  }
  
  public RemoteStorageManagerBuilder(RemoteStorageManagerFluent<?> fluent) {
    this(fluent, new RemoteStorageManager());
  }
  
  public RemoteStorageManagerBuilder(RemoteStorageManagerFluent<?> fluent,RemoteStorageManager instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RemoteStorageManagerBuilder(RemoteStorageManager instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RemoteStorageManagerFluent<?> fluent;
  
  public RemoteStorageManager build() {
    RemoteStorageManager buildable = new RemoteStorageManager();
    buildable.setClassName(fluent.getClassName());
    buildable.setClassPath(fluent.getClassPath());
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  

}