package io.strimzi.api.kafka.model.kafka.quotas;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Double;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QuotasPluginStrimziFluent<A extends QuotasPluginStrimziFluent<A>> extends BaseFluent<A>{
  public QuotasPluginStrimziFluent() {
  }
  
  public QuotasPluginStrimziFluent(QuotasPluginStrimzi instance) {
    this.copyInstance(instance);
  }
  private Long producerByteRate;
  private Long consumerByteRate;
  private Long minAvailableBytesPerVolume;
  private Double minAvailableRatioPerVolume;
  private List<String> excludedPrincipals;
  
  protected void copyInstance(QuotasPluginStrimzi instance) {
    instance = (instance != null ? instance : new QuotasPluginStrimzi());
    if (instance != null) {
          this.withProducerByteRate(instance.getProducerByteRate());
          this.withConsumerByteRate(instance.getConsumerByteRate());
          this.withMinAvailableBytesPerVolume(instance.getMinAvailableBytesPerVolume());
          this.withMinAvailableRatioPerVolume(instance.getMinAvailableRatioPerVolume());
          this.withExcludedPrincipals(instance.getExcludedPrincipals());
        }
  }
  
  public Long getProducerByteRate() {
    return this.producerByteRate;
  }
  
  public A withProducerByteRate(Long producerByteRate) {
    this.producerByteRate = producerByteRate;
    return (A) this;
  }
  
  public boolean hasProducerByteRate() {
    return this.producerByteRate != null;
  }
  
  public Long getConsumerByteRate() {
    return this.consumerByteRate;
  }
  
  public A withConsumerByteRate(Long consumerByteRate) {
    this.consumerByteRate = consumerByteRate;
    return (A) this;
  }
  
  public boolean hasConsumerByteRate() {
    return this.consumerByteRate != null;
  }
  
  public Long getMinAvailableBytesPerVolume() {
    return this.minAvailableBytesPerVolume;
  }
  
  public A withMinAvailableBytesPerVolume(Long minAvailableBytesPerVolume) {
    this.minAvailableBytesPerVolume = minAvailableBytesPerVolume;
    return (A) this;
  }
  
  public boolean hasMinAvailableBytesPerVolume() {
    return this.minAvailableBytesPerVolume != null;
  }
  
  public Double getMinAvailableRatioPerVolume() {
    return this.minAvailableRatioPerVolume;
  }
  
  public A withMinAvailableRatioPerVolume(Double minAvailableRatioPerVolume) {
    this.minAvailableRatioPerVolume = minAvailableRatioPerVolume;
    return (A) this;
  }
  
  public boolean hasMinAvailableRatioPerVolume() {
    return this.minAvailableRatioPerVolume != null;
  }
  
  public A addToExcludedPrincipals(int index,String item) {
    if (this.excludedPrincipals == null) {this.excludedPrincipals = new ArrayList<String>();}
    this.excludedPrincipals.add(index, item);
    return (A)this;
  }
  
  public A setToExcludedPrincipals(int index,String item) {
    if (this.excludedPrincipals == null) {this.excludedPrincipals = new ArrayList<String>();}
    this.excludedPrincipals.set(index, item); return (A)this;
  }
  
  public A addToExcludedPrincipals(java.lang.String... items) {
    if (this.excludedPrincipals == null) {this.excludedPrincipals = new ArrayList<String>();}
    for (String item : items) {this.excludedPrincipals.add(item);} return (A)this;
  }
  
  public A addAllToExcludedPrincipals(Collection<String> items) {
    if (this.excludedPrincipals == null) {this.excludedPrincipals = new ArrayList<String>();}
    for (String item : items) {this.excludedPrincipals.add(item);} return (A)this;
  }
  
  public A removeFromExcludedPrincipals(java.lang.String... items) {
    if (this.excludedPrincipals == null) return (A)this;
    for (String item : items) { this.excludedPrincipals.remove(item);} return (A)this;
  }
  
  public A removeAllFromExcludedPrincipals(Collection<String> items) {
    if (this.excludedPrincipals == null) return (A)this;
    for (String item : items) { this.excludedPrincipals.remove(item);} return (A)this;
  }
  
  public List<String> getExcludedPrincipals() {
    return this.excludedPrincipals;
  }
  
  public String getExcludedPrincipal(int index) {
    return this.excludedPrincipals.get(index);
  }
  
  public String getFirstExcludedPrincipal() {
    return this.excludedPrincipals.get(0);
  }
  
  public String getLastExcludedPrincipal() {
    return this.excludedPrincipals.get(excludedPrincipals.size() - 1);
  }
  
  public String getMatchingExcludedPrincipal(Predicate<String> predicate) {
      for (String item : excludedPrincipals) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingExcludedPrincipal(Predicate<String> predicate) {
      for (String item : excludedPrincipals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExcludedPrincipals(List<String> excludedPrincipals) {
    if (excludedPrincipals != null) {
        this.excludedPrincipals = new ArrayList();
        for (String item : excludedPrincipals) {
          this.addToExcludedPrincipals(item);
        }
    } else {
      this.excludedPrincipals = null;
    }
    return (A) this;
  }
  
  public A withExcludedPrincipals(java.lang.String... excludedPrincipals) {
    if (this.excludedPrincipals != null) {
        this.excludedPrincipals.clear();
        _visitables.remove("excludedPrincipals");
    }
    if (excludedPrincipals != null) {
      for (String item : excludedPrincipals) {
        this.addToExcludedPrincipals(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExcludedPrincipals() {
    return this.excludedPrincipals != null && !this.excludedPrincipals.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QuotasPluginStrimziFluent that = (QuotasPluginStrimziFluent) o;
    if (!java.util.Objects.equals(producerByteRate, that.producerByteRate)) return false;
    if (!java.util.Objects.equals(consumerByteRate, that.consumerByteRate)) return false;
    if (!java.util.Objects.equals(minAvailableBytesPerVolume, that.minAvailableBytesPerVolume)) return false;
    if (!java.util.Objects.equals(minAvailableRatioPerVolume, that.minAvailableRatioPerVolume)) return false;
    if (!java.util.Objects.equals(excludedPrincipals, that.excludedPrincipals)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(producerByteRate,  consumerByteRate,  minAvailableBytesPerVolume,  minAvailableRatioPerVolume,  excludedPrincipals,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (producerByteRate != null) { sb.append("producerByteRate:"); sb.append(producerByteRate + ","); }
    if (consumerByteRate != null) { sb.append("consumerByteRate:"); sb.append(consumerByteRate + ","); }
    if (minAvailableBytesPerVolume != null) { sb.append("minAvailableBytesPerVolume:"); sb.append(minAvailableBytesPerVolume + ","); }
    if (minAvailableRatioPerVolume != null) { sb.append("minAvailableRatioPerVolume:"); sb.append(minAvailableRatioPerVolume + ","); }
    if (excludedPrincipals != null && !excludedPrincipals.isEmpty()) { sb.append("excludedPrincipals:"); sb.append(excludedPrincipals); }
    sb.append("}");
    return sb.toString();
  }
  

}