package io.strimzi.api.kafka.model.kafka.quotas;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QuotasPluginStrimziBuilder extends QuotasPluginStrimziFluent<QuotasPluginStrimziBuilder> implements VisitableBuilder<QuotasPluginStrimzi,QuotasPluginStrimziBuilder>{
  public QuotasPluginStrimziBuilder() {
    this(new QuotasPluginStrimzi());
  }
  
  public QuotasPluginStrimziBuilder(QuotasPluginStrimziFluent<?> fluent) {
    this(fluent, new QuotasPluginStrimzi());
  }
  
  public QuotasPluginStrimziBuilder(QuotasPluginStrimziFluent<?> fluent,QuotasPluginStrimzi instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QuotasPluginStrimziBuilder(QuotasPluginStrimzi instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QuotasPluginStrimziFluent<?> fluent;
  
  public QuotasPluginStrimzi build() {
    QuotasPluginStrimzi buildable = new QuotasPluginStrimzi();
    buildable.setProducerByteRate(fluent.getProducerByteRate());
    buildable.setConsumerByteRate(fluent.getConsumerByteRate());
    buildable.setMinAvailableBytesPerVolume(fluent.getMinAvailableBytesPerVolume());
    buildable.setMinAvailableRatioPerVolume(fluent.getMinAvailableRatioPerVolume());
    buildable.setExcludedPrincipals(fluent.getExcludedPrincipals());
    return buildable;
  }
  

}