package io.strimzi.api.kafka.model.kafka.quotas;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Double;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QuotasPluginKafkaFluent<A extends QuotasPluginKafkaFluent<A>> extends BaseFluent<A>{
  public QuotasPluginKafkaFluent() {
  }
  
  public QuotasPluginKafkaFluent(QuotasPluginKafka instance) {
    this.copyInstance(instance);
  }
  private Long producerByteRate;
  private Long consumerByteRate;
  private Integer requestPercentage;
  private Double controllerMutationRate;
  
  protected void copyInstance(QuotasPluginKafka instance) {
    instance = (instance != null ? instance : new QuotasPluginKafka());
    if (instance != null) {
          this.withProducerByteRate(instance.getProducerByteRate());
          this.withConsumerByteRate(instance.getConsumerByteRate());
          this.withRequestPercentage(instance.getRequestPercentage());
          this.withControllerMutationRate(instance.getControllerMutationRate());
        }
  }
  
  public Long getProducerByteRate() {
    return this.producerByteRate;
  }
  
  public A withProducerByteRate(Long producerByteRate) {
    this.producerByteRate = producerByteRate;
    return (A) this;
  }
  
  public boolean hasProducerByteRate() {
    return this.producerByteRate != null;
  }
  
  public Long getConsumerByteRate() {
    return this.consumerByteRate;
  }
  
  public A withConsumerByteRate(Long consumerByteRate) {
    this.consumerByteRate = consumerByteRate;
    return (A) this;
  }
  
  public boolean hasConsumerByteRate() {
    return this.consumerByteRate != null;
  }
  
  public Integer getRequestPercentage() {
    return this.requestPercentage;
  }
  
  public A withRequestPercentage(Integer requestPercentage) {
    this.requestPercentage = requestPercentage;
    return (A) this;
  }
  
  public boolean hasRequestPercentage() {
    return this.requestPercentage != null;
  }
  
  public Double getControllerMutationRate() {
    return this.controllerMutationRate;
  }
  
  public A withControllerMutationRate(Double controllerMutationRate) {
    this.controllerMutationRate = controllerMutationRate;
    return (A) this;
  }
  
  public boolean hasControllerMutationRate() {
    return this.controllerMutationRate != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QuotasPluginKafkaFluent that = (QuotasPluginKafkaFluent) o;
    if (!java.util.Objects.equals(producerByteRate, that.producerByteRate)) return false;
    if (!java.util.Objects.equals(consumerByteRate, that.consumerByteRate)) return false;
    if (!java.util.Objects.equals(requestPercentage, that.requestPercentage)) return false;
    if (!java.util.Objects.equals(controllerMutationRate, that.controllerMutationRate)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(producerByteRate,  consumerByteRate,  requestPercentage,  controllerMutationRate,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (producerByteRate != null) { sb.append("producerByteRate:"); sb.append(producerByteRate + ","); }
    if (consumerByteRate != null) { sb.append("consumerByteRate:"); sb.append(consumerByteRate + ","); }
    if (requestPercentage != null) { sb.append("requestPercentage:"); sb.append(requestPercentage + ","); }
    if (controllerMutationRate != null) { sb.append("controllerMutationRate:"); sb.append(controllerMutationRate); }
    sb.append("}");
    return sb.toString();
  }
  

}