package io.strimzi.api.kafka.model.kafka.quotas;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QuotasPluginKafkaBuilder extends QuotasPluginKafkaFluent<QuotasPluginKafkaBuilder> implements VisitableBuilder<QuotasPluginKafka,QuotasPluginKafkaBuilder>{
  public QuotasPluginKafkaBuilder() {
    this(new QuotasPluginKafka());
  }
  
  public QuotasPluginKafkaBuilder(QuotasPluginKafkaFluent<?> fluent) {
    this(fluent, new QuotasPluginKafka());
  }
  
  public QuotasPluginKafkaBuilder(QuotasPluginKafkaFluent<?> fluent,QuotasPluginKafka instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QuotasPluginKafkaBuilder(QuotasPluginKafka instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QuotasPluginKafkaFluent<?> fluent;
  
  public QuotasPluginKafka build() {
    QuotasPluginKafka buildable = new QuotasPluginKafka();
    buildable.setProducerByteRate(fluent.getProducerByteRate());
    buildable.setConsumerByteRate(fluent.getConsumerByteRate());
    buildable.setRequestPercentage(fluent.getRequestPercentage());
    buildable.setControllerMutationRate(fluent.getControllerMutationRate());
    return buildable;
  }
  

}