package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ListenerStatusBuilder extends ListenerStatusFluent<ListenerStatusBuilder> implements VisitableBuilder<ListenerStatus,ListenerStatusBuilder>{
  public ListenerStatusBuilder() {
    this(new ListenerStatus());
  }
  
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent) {
    this(fluent, new ListenerStatus());
  }
  
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ListenerStatusBuilder(ListenerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ListenerStatusFluent<?> fluent;
  
  public ListenerStatus build() {
    ListenerStatus buildable = new ListenerStatus();
    buildable.setType(fluent.getType());
    buildable.setName(fluent.getName());
    buildable.setAddresses(fluent.buildAddresses());
    buildable.setCertificates(fluent.getCertificates());
    return buildable;
  }
  

}